/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.sale.db.ConfiguratorCreator;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SALE_CONFIGURATOR", indexes={@Index(columnList="configurator_creator"), @Index(columnList="configuratorCreatorName"), @Index(columnList="product")})
public class Configurator
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SALE_CONFIGURATOR_SEQ")
    @SequenceGenerator(name="SALE_CONFIGURATOR_SEQ", sequenceName="SALE_CONFIGURATOR_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Configurator type")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ConfiguratorCreator configuratorCreator;
    @Widget(hidden=true)
    @NameColumn
    private String configuratorCreatorName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attributes;
    @Widget(title="Indicators")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String indicators;
    @Widget(title="Product")
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ConfiguratorCreator getConfiguratorCreator() {
        return this.configuratorCreator;
    }

    public void setConfiguratorCreator(ConfiguratorCreator configuratorCreator) {
        this.configuratorCreator = configuratorCreator;
    }

    public String getConfiguratorCreatorName() {
        return this.configuratorCreatorName;
    }

    public void setConfiguratorCreatorName(String configuratorCreatorName) {
        this.configuratorCreatorName = configuratorCreatorName;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public String getIndicators() {
        return this.indicators;
    }

    public void setIndicators(String indicators) {
        this.indicators = indicators;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Configurator)) {
            return false;
        }
        Configurator other = (Configurator)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("configuratorCreatorName", (Object)this.getConfiguratorCreatorName()).omitNullValues().toString();
    }
}

