/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SALE_CUSTOMER_CATALOG", indexes={@Index(columnList="product"), @Index(columnList="customer_partner")})
public class CustomerCatalog
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SALE_CUSTOMER_CATALOG_SEQ")
    @SequenceGenerator(name="SALE_CUSTOMER_CATALOG_SEQ", sequenceName="SALE_CUSTOMER_CATALOG_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Product")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Customer")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner customerPartner;
    @Widget(title="Product name on catalog")
    private String productCustomerName;
    @Widget(title="Product code on catalog")
    private String productCustomerCode;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Partner getCustomerPartner() {
        return this.customerPartner;
    }

    public void setCustomerPartner(Partner customerPartner) {
        this.customerPartner = customerPartner;
    }

    public String getProductCustomerName() {
        return this.productCustomerName;
    }

    public void setProductCustomerName(String productCustomerName) {
        this.productCustomerName = productCustomerName;
    }

    public String getProductCustomerCode() {
        return this.productCustomerCode;
    }

    public void setProductCustomerCode(String productCustomerCode) {
        this.productCustomerCode = productCustomerCode;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CustomerCatalog)) {
            return false;
        }
        CustomerCatalog other = (CustomerCatalog)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("productCustomerName", (Object)this.getProductCustomerName()).add("productCustomerCode", (Object)this.getProductCustomerCode()).omitNullValues().toString();
    }
}

