/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SALE_PACK_LINE", indexes={@Index(columnList="product"), @Index(columnList="unit")})
public class PackLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SALE_PACK_LINE_SEQ")
    @SequenceGenerator(name="SALE_PACK_LINE_SEQ", sequenceName="SALE_PACK_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Seq.")
    private Integer sequence = 0;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Displayed Product name")
    private String productName;
    @Widget(title="Qty")
    @Digits(integer=10, fraction=10)
    private BigDecimal quantity = BigDecimal.ZERO;
    @Widget(title="Price")
    private BigDecimal price = BigDecimal.ZERO;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Type", selection="line.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Show Total")
    private Boolean isShowTotal = Boolean.FALSE;
    @Widget(title="Hide Unit Amounts")
    private Boolean isHideUnitAmounts = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public BigDecimal getQuantity() {
        return this.quantity == null ? BigDecimal.ZERO : this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getPrice() {
        return this.price == null ? BigDecimal.ZERO : this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Boolean getIsShowTotal() {
        return this.isShowTotal == null ? Boolean.FALSE : this.isShowTotal;
    }

    public void setIsShowTotal(Boolean isShowTotal) {
        this.isShowTotal = isShowTotal;
    }

    public Boolean getIsHideUnitAmounts() {
        return this.isHideUnitAmounts == null ? Boolean.FALSE : this.isHideUnitAmounts;
    }

    public void setIsHideUnitAmounts(Boolean isHideUnitAmounts) {
        this.isHideUnitAmounts = isHideUnitAmounts;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PackLine)) {
            return false;
        }
        PackLine other = (PackLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("sequence", (Object)this.getSequence()).add("productName", (Object)this.getProductName()).add("quantity", (Object)this.getQuantity()).add("price", (Object)this.getPrice()).add("typeSelect", (Object)this.getTypeSelect()).add("isShowTotal", (Object)this.getIsShowTotal()).add("isHideUnitAmounts", (Object)this.getIsHideUnitAmounts()).omitNullValues().toString();
    }
}

