/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.db;

import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="SALE_SALE_ORDER_LINE", indexes={@Index(columnList="fullName"), @Index(columnList="sale_order"), @Index(columnList="product"), @Index(columnList="tax_line"), @Index(columnList="tax_equiv"), @Index(columnList="unit"), @Index(columnList="supplier_partner")})
public class SaleOrderLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SALE_SALE_ORDER_LINE_SEQ")
    @SequenceGenerator(name="SALE_SALE_ORDER_LINE_SEQ", sequenceName="SALE_SALE_ORDER_LINE_SEQ", allocationSize=1)
    private Long id;
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Sale order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrder saleOrder;
    @Widget(title="Seq.")
    private Integer sequence = 0;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Qty")
    @Digits(integer=10, fraction=10)
    private BigDecimal qty = new BigDecimal("1");
    @Widget(hidden=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal oldQty = BigDecimal.ZERO;
    @Widget(title="Print subtotal / line")
    private Boolean isToPrintLineSubTotal = Boolean.FALSE;
    @Widget(title="Displayed Product name", translatable=true)
    @NotNull
    private String productName;
    @Widget(title="Unit price W.T.")
    @Digits(integer=10, fraction=10)
    private BigDecimal price = BigDecimal.ZERO;
    @Widget(title="Unit price A.T.I.")
    @Digits(integer=10, fraction=10)
    private BigDecimal inTaxPrice = BigDecimal.ZERO;
    @Widget(title="Unit price discounted")
    @Digits(integer=10, fraction=10)
    private BigDecimal priceDiscounted = BigDecimal.ZERO;
    @Widget(title="Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine taxLine;
    @Widget(title="Tax Equiv")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxEquiv taxEquiv;
    @Widget(title="Total W.T.")
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.")
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Supplier")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner supplierPartner;
    @Widget(title="Discount amount")
    @Digits(integer=10, fraction=10)
    private BigDecimal discountAmount = BigDecimal.ZERO;
    @Widget(title="Discount type", selection="base.price.list.line.amount.type.select")
    private Integer discountTypeSelect = 0;
    @Widget(title="Estimated shipping date")
    private LocalDate estimatedDelivDate;
    @Widget(title="Desired delivery date")
    private LocalDate desiredDelivDate;
    @Widget(title="Delivered quantity")
    @Digits(integer=10, fraction=10)
    private BigDecimal deliveredQty = BigDecimal.ZERO;
    @Widget(title="SubTotal cost price")
    private BigDecimal subTotalCostPrice = BigDecimal.ZERO;
    @Widget(title="Sub Total gross profit")
    private BigDecimal subTotalGrossMargin = BigDecimal.ZERO;
    @Widget(title="Sub margin rate")
    private BigDecimal subMarginRate = BigDecimal.ZERO;
    @Widget(title="Sub Total markup")
    private BigDecimal subTotalMarkup = BigDecimal.ZERO;
    @Widget(title="Total W.T. in company currency", hidden=true)
    private BigDecimal companyExTaxTotal = BigDecimal.ZERO;
    @Widget(title="Unit cost price in company currency", hidden=true)
    private BigDecimal companyCostPrice = BigDecimal.ZERO;
    @Widget(title="Total A.T.I. in company currency", hidden=true)
    private BigDecimal companyInTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total cost in company currency", hidden=true)
    private BigDecimal companyCostTotal = BigDecimal.ZERO;
    @Widget(title="Type", selection="line.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Show Total")
    private Boolean isShowTotal = Boolean.FALSE;
    @Widget(title="Hide Unit Amounts")
    private Boolean isHideUnitAmounts = Boolean.FALSE;
    @Widget(title="Freeze fields")
    @Transient
    private Boolean enableFreezeFields = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullName = "";
        if (this.saleOrder != null && this.saleOrder.getSaleOrderSeq() != null) {
            fullName = fullName + this.saleOrder.getSaleOrderSeq();
        }
        if (this.productName != null) {
            fullName = fullName + "-";
            fullName = this.productName.length() > 100 ? fullName + this.productName.substring(1, 100) : fullName + this.productName;
        }
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public SaleOrder getSaleOrder() {
        return this.saleOrder;
    }

    public void setSaleOrder(SaleOrder saleOrder) {
        this.saleOrder = saleOrder;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public BigDecimal getOldQty() {
        return this.oldQty == null ? BigDecimal.ZERO : this.oldQty;
    }

    public void setOldQty(BigDecimal oldQty) {
        this.oldQty = oldQty;
    }

    public Boolean getIsToPrintLineSubTotal() {
        return this.isToPrintLineSubTotal == null ? Boolean.FALSE : this.isToPrintLineSubTotal;
    }

    public void setIsToPrintLineSubTotal(Boolean isToPrintLineSubTotal) {
        this.isToPrintLineSubTotal = isToPrintLineSubTotal;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public BigDecimal getPrice() {
        return this.price == null ? BigDecimal.ZERO : this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getInTaxPrice() {
        return this.inTaxPrice == null ? BigDecimal.ZERO : this.inTaxPrice;
    }

    public void setInTaxPrice(BigDecimal inTaxPrice) {
        this.inTaxPrice = inTaxPrice;
    }

    public BigDecimal getPriceDiscounted() {
        return this.priceDiscounted == null ? BigDecimal.ZERO : this.priceDiscounted;
    }

    public void setPriceDiscounted(BigDecimal priceDiscounted) {
        this.priceDiscounted = priceDiscounted;
    }

    public TaxLine getTaxLine() {
        return this.taxLine;
    }

    public void setTaxLine(TaxLine taxLine) {
        this.taxLine = taxLine;
    }

    public TaxEquiv getTaxEquiv() {
        return this.taxEquiv;
    }

    public void setTaxEquiv(TaxEquiv taxEquiv) {
        this.taxEquiv = taxEquiv;
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Partner getSupplierPartner() {
        return this.supplierPartner;
    }

    public void setSupplierPartner(Partner supplierPartner) {
        this.supplierPartner = supplierPartner;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount == null ? BigDecimal.ZERO : this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public Integer getDiscountTypeSelect() {
        return this.discountTypeSelect == null ? 0 : this.discountTypeSelect;
    }

    public void setDiscountTypeSelect(Integer discountTypeSelect) {
        this.discountTypeSelect = discountTypeSelect;
    }

    public LocalDate getEstimatedDelivDate() {
        return this.estimatedDelivDate;
    }

    public void setEstimatedDelivDate(LocalDate estimatedDelivDate) {
        this.estimatedDelivDate = estimatedDelivDate;
    }

    public LocalDate getDesiredDelivDate() {
        return this.desiredDelivDate;
    }

    public void setDesiredDelivDate(LocalDate desiredDelivDate) {
        this.desiredDelivDate = desiredDelivDate;
    }

    public BigDecimal getDeliveredQty() {
        return this.deliveredQty == null ? BigDecimal.ZERO : this.deliveredQty;
    }

    public void setDeliveredQty(BigDecimal deliveredQty) {
        this.deliveredQty = deliveredQty;
    }

    public BigDecimal getSubTotalCostPrice() {
        return this.subTotalCostPrice == null ? BigDecimal.ZERO : this.subTotalCostPrice;
    }

    public void setSubTotalCostPrice(BigDecimal subTotalCostPrice) {
        this.subTotalCostPrice = subTotalCostPrice;
    }

    public BigDecimal getSubTotalGrossMargin() {
        return this.subTotalGrossMargin == null ? BigDecimal.ZERO : this.subTotalGrossMargin;
    }

    public void setSubTotalGrossMargin(BigDecimal subTotalGrossMargin) {
        this.subTotalGrossMargin = subTotalGrossMargin;
    }

    public BigDecimal getSubMarginRate() {
        return this.subMarginRate == null ? BigDecimal.ZERO : this.subMarginRate;
    }

    public void setSubMarginRate(BigDecimal subMarginRate) {
        this.subMarginRate = subMarginRate;
    }

    public BigDecimal getSubTotalMarkup() {
        return this.subTotalMarkup == null ? BigDecimal.ZERO : this.subTotalMarkup;
    }

    public void setSubTotalMarkup(BigDecimal subTotalMarkup) {
        this.subTotalMarkup = subTotalMarkup;
    }

    public BigDecimal getCompanyExTaxTotal() {
        return this.companyExTaxTotal == null ? BigDecimal.ZERO : this.companyExTaxTotal;
    }

    public void setCompanyExTaxTotal(BigDecimal companyExTaxTotal) {
        this.companyExTaxTotal = companyExTaxTotal;
    }

    public BigDecimal getCompanyCostPrice() {
        return this.companyCostPrice == null ? BigDecimal.ZERO : this.companyCostPrice;
    }

    public void setCompanyCostPrice(BigDecimal companyCostPrice) {
        this.companyCostPrice = companyCostPrice;
    }

    public BigDecimal getCompanyInTaxTotal() {
        return this.companyInTaxTotal == null ? BigDecimal.ZERO : this.companyInTaxTotal;
    }

    public void setCompanyInTaxTotal(BigDecimal companyInTaxTotal) {
        this.companyInTaxTotal = companyInTaxTotal;
    }

    public BigDecimal getCompanyCostTotal() {
        return this.companyCostTotal == null ? BigDecimal.ZERO : this.companyCostTotal;
    }

    public void setCompanyCostTotal(BigDecimal companyCostTotal) {
        this.companyCostTotal = companyCostTotal;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Boolean getIsShowTotal() {
        return this.isShowTotal == null ? Boolean.FALSE : this.isShowTotal;
    }

    public void setIsShowTotal(Boolean isShowTotal) {
        this.isShowTotal = isShowTotal;
    }

    public Boolean getIsHideUnitAmounts() {
        return this.isHideUnitAmounts == null ? Boolean.FALSE : this.isHideUnitAmounts;
    }

    public void setIsHideUnitAmounts(Boolean isHideUnitAmounts) {
        this.isHideUnitAmounts = isHideUnitAmounts;
    }

    public Boolean getEnableFreezeFields() {
        return this.enableFreezeFields == null ? Boolean.FALSE : this.enableFreezeFields;
    }

    public void setEnableFreezeFields(Boolean enableFreezeFields) {
        this.enableFreezeFields = enableFreezeFields;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SaleOrderLine)) {
            return false;
        }
        SaleOrderLine other = (SaleOrderLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("sequence", (Object)this.getSequence()).add("qty", (Object)this.getQty()).add("oldQty", (Object)this.getOldQty()).add("isToPrintLineSubTotal", (Object)this.getIsToPrintLineSubTotal()).add("productName", (Object)this.getProductName()).add("price", (Object)this.getPrice()).add("inTaxPrice", (Object)this.getInTaxPrice()).add("priceDiscounted", (Object)this.getPriceDiscounted()).add("exTaxTotal", (Object)this.getExTaxTotal()).add("inTaxTotal", (Object)this.getInTaxTotal()).add("discountAmount", (Object)this.getDiscountAmount()).omitNullValues().toString();
    }
}

