/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.db;

import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SALE_SALE_ORDER_LINE_TAX", indexes={@Index(columnList="sale_order"), @Index(columnList="tax_line")})
public class SaleOrderLineTax
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SALE_SALE_ORDER_LINE_TAX_SEQ")
    @SequenceGenerator(name="SALE_SALE_ORDER_LINE_TAX_SEQ", sequenceName="SALE_SALE_ORDER_LINE_TAX_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Sale order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrder saleOrder;
    @Widget(title="Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine taxLine;
    @Widget(title="Base W.T.")
    @Digits(integer=18, fraction=2)
    private BigDecimal exTaxBase = BigDecimal.ZERO;
    @Widget(title="Amount Tax")
    @Digits(integer=18, fraction=2)
    private BigDecimal taxTotal = BigDecimal.ZERO;
    @Widget(title="Amount A.T.I.")
    @Digits(integer=18, fraction=2)
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SaleOrder getSaleOrder() {
        return this.saleOrder;
    }

    public void setSaleOrder(SaleOrder saleOrder) {
        this.saleOrder = saleOrder;
    }

    public TaxLine getTaxLine() {
        return this.taxLine;
    }

    public void setTaxLine(TaxLine taxLine) {
        this.taxLine = taxLine;
    }

    public BigDecimal getExTaxBase() {
        return this.exTaxBase == null ? BigDecimal.ZERO : this.exTaxBase;
    }

    public void setExTaxBase(BigDecimal exTaxBase) {
        this.exTaxBase = exTaxBase;
    }

    public BigDecimal getTaxTotal() {
        return this.taxTotal == null ? BigDecimal.ZERO : this.taxTotal;
    }

    public void setTaxTotal(BigDecimal taxTotal) {
        this.taxTotal = taxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SaleOrderLineTax)) {
            return false;
        }
        SaleOrderLineTax other = (SaleOrderLineTax)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("exTaxBase", (Object)this.getExTaxBase()).add("taxTotal", (Object)this.getTaxTotal()).add("inTaxTotal", (Object)this.getInTaxTotal()).omitNullValues().toString();
    }
}

