/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.db.repo;

import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.app.AppSaleService;
import com.axelor.apps.sale.service.saleorder.SaleOrderComputeService;
import com.axelor.apps.sale.service.saleorder.SaleOrderLineService;
import com.axelor.apps.sale.service.saleorder.SaleOrderMarginService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.math.BigDecimal;
import javax.persistence.PersistenceException;

public class SaleOrderManagementRepository
extends SaleOrderRepository {
    @Inject
    SaleOrderComputeService saleOrderComputeService;

    public SaleOrder copy(SaleOrder entity, boolean deep) {
        SaleOrder copy = (SaleOrder)((Object)super.copy((Model)((Object)entity), deep));
        copy.setStatusSelect(1);
        copy.setSaleOrderSeq(null);
        copy.clearBatchSet();
        copy.setImportId(null);
        copy.setCreationDate(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(entity.getCompany()));
        copy.setConfirmationDateTime(null);
        copy.setConfirmedByUser(null);
        copy.setOrderDate(null);
        copy.setOrderNumber(null);
        copy.setVersionNumber(1);
        copy.setTotalCostPrice(null);
        copy.setTotalGrossMargin(null);
        copy.setMarginRate(null);
        copy.setEndOfValidityDate(null);
        copy.setDeliveryDate(null);
        copy.setOrderBeingEdited(false);
        if (copy.getAdvancePaymentAmountNeeded().compareTo(copy.getAdvanceTotal()) <= 0) {
            copy.setAdvancePaymentAmountNeeded(BigDecimal.ZERO);
            copy.setAdvancePaymentNeeded(false);
            copy.clearAdvancePaymentList();
        }
        if (copy.getSaleOrderLineList() != null) {
            for (SaleOrderLine saleOrderLine : copy.getSaleOrderLineList()) {
                saleOrderLine.setDesiredDelivDate(null);
                saleOrderLine.setEstimatedDelivDate(null);
            }
        }
        return copy;
    }

    public SaleOrder save(SaleOrder saleOrder) {
        try {
            if (((AppSaleService)Beans.get(AppSaleService.class)).getAppSale().getEnablePackManagement().booleanValue()) {
                this.saleOrderComputeService.computePackTotal(saleOrder);
            } else {
                this.saleOrderComputeService.resetPackTotal(saleOrder);
            }
            this.computeSeq(saleOrder);
            this.computeFullName(saleOrder);
            this.computeSubMargin(saleOrder);
            ((SaleOrderMarginService)Beans.get(SaleOrderMarginService.class)).computeMarginSaleOrder(saleOrder);
            return (SaleOrder)((Object)super.save((Model)((Object)saleOrder)));
        }
        catch (Exception e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }

    public void computeSeq(SaleOrder saleOrder) {
        try {
            if (saleOrder.getId() == null) {
                saleOrder = (SaleOrder)((Object)super.save((Model)((Object)saleOrder)));
            }
            if (Strings.isNullOrEmpty((String)saleOrder.getSaleOrderSeq()) && !saleOrder.getTemplate().booleanValue() && saleOrder.getStatusSelect() == 1) {
                saleOrder.setSaleOrderSeq(((SequenceService)Beans.get(SequenceService.class)).getDraftSequenceNumber((Model)((Object)saleOrder)));
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }

    public void computeFullName(SaleOrder saleOrder) {
        try {
            if (saleOrder.getClientPartner() != null) {
                String fullName = saleOrder.getClientPartner().getName();
                if (!Strings.isNullOrEmpty((String)saleOrder.getSaleOrderSeq())) {
                    fullName = saleOrder.getSaleOrderSeq() + "-" + fullName;
                }
                saleOrder.setFullName(fullName);
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }

    public void computeSubMargin(SaleOrder saleOrder) throws AxelorException {
        if (saleOrder.getSaleOrderLineList() != null) {
            for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
                ((SaleOrderLineService)Beans.get(SaleOrderLineService.class)).computeSubMargin(saleOrder, saleOrderLine);
            }
        }
    }
}

