/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.service;

import com.axelor.apps.base.db.ABCAnalysis;
import com.axelor.apps.base.db.ABCAnalysisLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ABCAnalysisClassRepository;
import com.axelor.apps.base.db.repo.ABCAnalysisLineRepository;
import com.axelor.apps.base.db.repo.ABCAnalysisRepository;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.ABCAnalysisServiceImpl;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderLineRepository;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class ABCAnalysisServiceSaleImpl
extends ABCAnalysisServiceImpl {
    protected SaleOrderLineRepository saleOrderLineRepository;
    private static final String SELLABLE_TRUE = " AND self.sellable = TRUE";

    @Inject
    public ABCAnalysisServiceSaleImpl(ABCAnalysisLineRepository abcAnalysisLineRepository, UnitConversionService unitConversionService, ABCAnalysisRepository abcAnalysisRepository, ProductRepository productRepository, SaleOrderLineRepository saleOrderLineRepository, ABCAnalysisClassRepository abcAnalysisClassRepository, SequenceService sequenceService) {
        super(abcAnalysisLineRepository, unitConversionService, abcAnalysisRepository, productRepository, abcAnalysisClassRepository, sequenceService);
        this.saleOrderLineRepository = saleOrderLineRepository;
    }

    protected Optional<ABCAnalysisLine> createABCAnalysisLine(ABCAnalysis abcAnalysis, Product product) throws AxelorException {
        List saleOrderLineList;
        ABCAnalysisLine abcAnalysisLine = null;
        BigDecimal productQty = BigDecimal.ZERO;
        BigDecimal productWorth = BigDecimal.ZERO;
        int offset = 0;
        Query saleOrderLineQuery = this.saleOrderLineRepository.all().filter("(self.saleOrder.statusSelect = :statusConfirmed OR self.saleOrder.statusSelect = :statusCompleted) AND self.saleOrder.confirmationDateTime >= :startDate AND self.saleOrder.confirmationDateTime <= :endDate AND self.product.id = :productId").bind("statusConfirmed", (Object)3).bind("statusCompleted", (Object)4).bind("startDate", (Object)DateTool.toLocalDateT((Date)DateTool.toDate((LocalDate)abcAnalysis.getStartDate()))).bind("endDate", (Object)DateTool.toLocalDateT((Date)DateTool.toDate((LocalDate)abcAnalysis.getEndDate())).withHour(23).withMinute(59).withSecond(59)).bind("productId", (Object)product.getId()).order("id");
        while (!(saleOrderLineList = saleOrderLineQuery.fetch(10, offset)).isEmpty()) {
            offset += saleOrderLineList.size();
            abcAnalysis = (ABCAnalysis)((Object)this.abcAnalysisRepository.find(abcAnalysis.getId()));
            if (abcAnalysisLine == null) {
                abcAnalysisLine = (ABCAnalysisLine)super.createABCAnalysisLine(abcAnalysis, product).get();
            }
            for (SaleOrderLine saleOrderLine : saleOrderLineList) {
                BigDecimal convertedQty = this.unitConversionService.convert(saleOrderLine.getUnit(), product.getUnit(), saleOrderLine.getQty(), 5, product);
                productQty = productQty.add(convertedQty);
                productWorth = productWorth.add(saleOrderLine.getCompanyExTaxTotal());
            }
            super.incTotalQty(productQty);
            super.incTotalWorth(productWorth);
            JPA.clear();
        }
        if (abcAnalysisLine != null) {
            this.setQtyWorth((ABCAnalysisLine)this.abcAnalysisLineRepository.find(abcAnalysisLine.getId()), productQty, productWorth);
        }
        return Optional.ofNullable(abcAnalysisLine);
    }

    protected String getProductCategoryQuery() {
        return super.getProductCategoryQuery() + SELLABLE_TRUE;
    }

    protected String getProductFamilyQuery() {
        return super.getProductFamilyQuery() + SELLABLE_TRUE;
    }
}

