/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.service.configurator;

import com.axelor.apps.sale.db.ConfiguratorCreator;
import com.axelor.apps.sale.db.ConfiguratorFormula;
import com.axelor.apps.sale.service.configurator.ConfiguratorCreatorImportService;
import com.axelor.apps.sale.service.configurator.ConfiguratorCreatorService;
import com.axelor.data.Listener;
import com.axelor.data.xml.XMLImporter;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaJsonField;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.xmlbeans.impl.common.IOUtil;

public class ConfiguratorCreatorImportServiceImpl
implements ConfiguratorCreatorImportService {
    protected ConfiguratorCreatorService configuratorCreatorService;
    private static final String CONFIG_FILE_PATH = "/data-import/import-configurator-creator-config.xml";

    @Inject
    public ConfiguratorCreatorImportServiceImpl(ConfiguratorCreatorService configuratorCreatorService) {
        this.configuratorCreatorService = configuratorCreatorService;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public String importConfiguratorCreators(String filePath) throws IOException {
        return this.importConfiguratorCreators(filePath, CONFIG_FILE_PATH);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public String importConfiguratorCreators(String filePath, String configFilePath) throws IOException {
        Path path = MetaFiles.getPath((String)filePath);
        try (FileInputStream fileInPutStream = new FileInputStream(path.toFile());){
            String string = this.importConfiguratorCreators(fileInPutStream, configFilePath);
            return string;
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public String importConfiguratorCreators(InputStream xmlInputStream) throws IOException {
        return this.importConfiguratorCreators(xmlInputStream, CONFIG_FILE_PATH);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public String importConfiguratorCreators(InputStream xmlInputStream, String configFilePath) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(configFilePath);
        File configFile = File.createTempFile("config", ".xml");
        FileOutputStream fout = new FileOutputStream(configFile);
        IOUtil.copyCompletely((InputStream)inputStream, (OutputStream)fout);
        File tempDir = Files.createTempDir();
        File importFile = new File(tempDir, "configurator-creator.xml");
        FileUtils.copyInputStreamToFile((InputStream)xmlInputStream, (File)importFile);
        XMLImporter importer = new XMLImporter(configFile.getAbsolutePath(), tempDir.getAbsolutePath());
        final StringBuilder importLog = new StringBuilder();
        Listener listener = new Listener(){

            public void imported(Integer imported, Integer total) {
                importLog.append("Total records: " + total + ", Total imported: " + total);
            }

            public void imported(Model arg0) {
                try {
                    ConfiguratorCreatorImportServiceImpl.this.completeAfterImport(arg0);
                }
                catch (AxelorException e) {
                    importLog.append("Error in import: " + Arrays.toString(e.getStackTrace()));
                }
            }

            public void handle(Model arg0, Exception err) {
                importLog.append("Error in import: " + Arrays.toString(err.getStackTrace()));
            }
        };
        importer.addListener(listener);
        importer.run();
        FileUtils.forceDelete((File)configFile);
        FileUtils.forceDelete((File)tempDir);
        return importLog.toString();
    }

    protected void completeAfterImport(Object arg0) throws AxelorException {
        if (arg0.getClass().equals(ConfiguratorCreator.class)) {
            this.completeAfterImport((ConfiguratorCreator)((Object)arg0));
        }
    }

    protected void completeAfterImport(ConfiguratorCreator creator) throws AxelorException {
        this.fixAttributesName(creator);
        this.configuratorCreatorService.updateAttributes(creator);
        this.configuratorCreatorService.updateIndicators(creator);
    }

    @Override
    public void fixAttributesName(ConfiguratorCreator creator) throws AxelorException {
        List<MetaJsonField> attributes = creator.getAttributes();
        if (attributes == null) {
            return;
        }
        for (MetaJsonField attribute : attributes) {
            String name = attribute.getName();
            if (name != null && name.contains("_")) {
                attribute.setName(name.substring(0, name.lastIndexOf(95)) + '_' + creator.getId());
            }
            this.updateAttributeNameInFormulas(creator, name, attribute.getName());
        }
    }

    protected void updateAttributeNameInFormulas(ConfiguratorCreator creator, String oldName, String newName) throws AxelorException {
        if (creator.getConfiguratorProductFormulaList() != null) {
            this.updateAttributeNameInFormulas(creator.getConfiguratorProductFormulaList(), oldName, newName);
        }
        if (creator.getConfiguratorSOLineFormulaList() != null) {
            this.updateAttributeNameInFormulas(creator.getConfiguratorSOLineFormulaList(), oldName, newName);
        }
    }

    protected void updateAttributeNameInFormulas(List<? extends ConfiguratorFormula> formulas, String oldAttributeName, String newAttributeName) {
        formulas.stream().forEach(configuratorFormula -> configuratorFormula.setFormula(configuratorFormula.getFormula().replace(oldAttributeName, newAttributeName)));
    }
}

