/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.service.configurator;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.sale.db.Configurator;
import com.axelor.apps.sale.db.ConfiguratorCreator;
import com.axelor.apps.sale.db.ConfiguratorFormula;
import com.axelor.apps.sale.db.ConfiguratorProductFormula;
import com.axelor.apps.sale.db.ConfiguratorSOLineFormula;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.ConfiguratorCreatorRepository;
import com.axelor.apps.sale.service.configurator.ConfiguratorCreatorService;
import com.axelor.apps.tool.StringTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.User;
import com.axelor.common.Inflector;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.annotations.Widget;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaFieldRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.script.ScriptBindings;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotNull;

public class ConfiguratorCreatorServiceImpl
implements ConfiguratorCreatorService {
    private ConfiguratorCreatorRepository configuratorCreatorRepo;
    private AppBaseService appBaseService;

    @Inject
    public ConfiguratorCreatorServiceImpl(ConfiguratorCreatorRepository configuratorCreatorRepo, AppBaseService appBaseService) {
        this.configuratorCreatorRepo = configuratorCreatorRepo;
        this.appBaseService = appBaseService;
    }

    @Override
    @Transactional
    public void updateAttributes(ConfiguratorCreator creator) {
        if (creator == null) {
            return;
        }
        for (MetaJsonField field : creator.getAttributes()) {
            this.setContextToJsonField(creator, field);
            if (!Strings.isNullOrEmpty((String)field.getOnChange())) continue;
            field.setOnChange("save,action-configurator-update-indicators,save");
        }
        this.configuratorCreatorRepo.save((Model)((Object)creator));
    }

    @Override
    @Transactional
    public void updateIndicators(ConfiguratorCreator creator) {
        List indicators = Optional.ofNullable(creator.getIndicators()).orElse(Collections.emptyList());
        List<ConfiguratorFormula> formulas = creator.getGenerateProduct() != false ? creator.getConfiguratorProductFormulaList() : creator.getConfiguratorSOLineFormulaList();
        for (ConfiguratorFormula formula : formulas) {
            this.addIfMissing(formula, creator);
        }
        ArrayList<MetaJsonField> fieldsToRemove = new ArrayList<MetaJsonField>();
        for (MetaJsonField indicator : indicators) {
            if (!this.isNotInFormulas(indicator, creator, formulas)) continue;
            fieldsToRemove.add(indicator);
        }
        for (MetaJsonField indicatorToRemove : fieldsToRemove) {
            creator.removeIndicator(indicatorToRemove);
        }
        this.updateIndicatorsAttrs(creator, formulas);
        this.configuratorCreatorRepo.save((Model)((Object)creator));
    }

    @Override
    public ScriptBindings getTestingValues(ConfiguratorCreator creator) {
        HashMap<String, Object> attributesValues = new HashMap<String, Object>();
        List<MetaJsonField> attributes = creator.getAttributes();
        if (attributes != null) {
            for (MetaJsonField attribute : attributes) {
                Object defaultAttribute = this.getAttributesDefaultValue(attribute);
                if (defaultAttribute == null) continue;
                attributesValues.put(attribute.getName(), this.getAttributesDefaultValue(attribute));
            }
        }
        return new ScriptBindings(attributesValues);
    }

    protected Object getAttributesDefaultValue(MetaJsonField attribute) {
        switch (attribute.getType()) {
            case "string": {
                return "a";
            }
            case "integer": {
                return 1;
            }
            case "decimal": {
                return BigDecimal.ONE;
            }
            case "boolean": {
                return true;
            }
            case "datetime": {
                return this.appBaseService.getTodayDateTime((Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null));
            }
            case "date": {
                return this.appBaseService.getTodayDate((Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null));
            }
            case "time": {
                return LocalTime.now();
            }
            case "panel": {
                return null;
            }
            case "enum": {
                return null;
            }
            case "button": {
                return null;
            }
            case "separator": {
                return null;
            }
            case "many-to-one": {
                return this.getAttributeRelationalField(attribute, "many-to-one");
            }
            case "many-to-many": {
                return this.getAttributeRelationalField(attribute, "many-to-many");
            }
            case "one-to-many": {
                return this.getAttributeRelationalField(attribute, "one-to-many");
            }
            case "json-many-to-one": {
                return null;
            }
            case "json-many-to-many": {
                return null;
            }
            case "json-one-to-many": {
                return null;
            }
        }
        return null;
    }

    protected Object getAttributeRelationalField(MetaJsonField attribute, String relation) {
        try {
            Class<?> targetClass = Class.forName(attribute.getTargetModel());
            if (relation.equals("many-to-one")) {
                return JPA.all(targetClass).fetchOne();
            }
            if (relation.equals("one-to-many")) {
                return JPA.all(targetClass).fetch(1);
            }
            if (relation.equals("many-to-many")) {
                return new HashSet(JPA.all(targetClass).fetch(1));
            }
            return null;
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            return null;
        }
    }

    protected void addIfMissing(ConfiguratorFormula formula, ConfiguratorCreator creator) {
        String typeName;
        MetaField formulaMetaField = formula.getMetaField();
        List fields = Optional.ofNullable(creator.getIndicators()).orElse(Collections.emptyList());
        for (MetaJsonField field : fields) {
            if (!field.getName().equals(formulaMetaField.getName() + "_" + creator.getId())) continue;
            return;
        }
        String metaModelName = formulaMetaField.getMetaModel().getName();
        MetaJsonField newField = new MetaJsonField();
        newField.setModel(Configurator.class.getName());
        newField.setModelField("indicators");
        MetaField metaField = (MetaField)((Object)((MetaFieldRepository)((Object)Beans.get(MetaFieldRepository.class))).all().filter("self.metaModel.name = :metaModelName AND self.name = :name").bind("metaModelName", (Object)metaModelName).bind("name", (Object)formulaMetaField.getName()).fetchOne());
        if (!Strings.isNullOrEmpty((String)metaField.getRelationship())) {
            typeName = metaField.getRelationship();
            this.completeDefaultGridAndForm(metaField, newField);
        } else {
            typeName = metaField.getTypeName();
        }
        this.completeSelection(metaField, newField);
        newField.setType(this.typeToJsonType(typeName));
        newField.setName(formulaMetaField.getName() + "_" + creator.getId());
        newField.setTitle(formulaMetaField.getLabel());
        creator.addIndicator(newField);
    }

    protected boolean isNotInFormulas(MetaJsonField field, ConfiguratorCreator creator, List<? extends ConfiguratorFormula> formulas) {
        for (ConfiguratorFormula configuratorFormula : formulas) {
            MetaField formulaMetaField = configuratorFormula.getMetaField();
            if (!(formulaMetaField.getName() + "_" + creator.getId()).equals(field.getName())) continue;
            return false;
        }
        return true;
    }

    protected void completeDefaultGridAndForm(MetaField metaField, MetaJsonField newField) {
        String name = metaField.getTypeName();
        if (Strings.isNullOrEmpty((String)name)) {
            return;
        }
        Inflector inflector = Inflector.getInstance();
        String prefix = inflector.dasherize(name);
        newField.setGridView(prefix + "-grid");
        newField.setFormView(prefix + "-form");
    }

    protected void completeSelection(MetaField metaField, MetaJsonField newField) {
        try {
            Field correspondingField = Class.forName(metaField.getMetaModel().getPackageName() + "." + metaField.getMetaModel().getName()).getDeclaredField(metaField.getName());
            Widget widget = correspondingField.getAnnotation(Widget.class);
            if (widget == null) {
                return;
            }
            String selection = widget.selection();
            if (!Strings.isNullOrEmpty((String)selection)) {
                newField.setSelection(selection);
            }
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    protected String typeToJsonType(String nameType) {
        if (nameType.equals("BigDecimal")) {
            return "decimal";
        }
        if (nameType.equals("ManyToOne")) {
            return "many-to-one";
        }
        if (nameType.equals("OneToMany")) {
            return "one-to-many";
        }
        if (nameType.equals("OneToOne")) {
            return "one-to-one";
        }
        if (nameType.equals("ManyToMany")) {
            return "many-to-many";
        }
        return nameType.toLowerCase();
    }

    protected void updateIndicatorsAttrs(ConfiguratorCreator creator, List<? extends ConfiguratorFormula> formulas) {
        List<MetaJsonField> indicators = creator.getIndicators();
        for (MetaJsonField indicator : indicators) {
            for (ConfiguratorFormula configuratorFormula : formulas) {
                this.updateIndicatorAttrs(creator, indicator, configuratorFormula);
            }
        }
    }

    protected void updateIndicatorAttrs(ConfiguratorCreator creator, MetaJsonField indicator, ConfiguratorFormula formula) {
        int scale = ((AppBaseService)Beans.get(AppBaseService.class)).getNbDecimalDigitForUnitPrice();
        String fieldName = indicator.getName();
        fieldName = fieldName.substring(0, fieldName.indexOf(95));
        MetaField metaField = formula.getMetaField();
        if (!metaField.getName().equals(fieldName)) {
            return;
        }
        if (formula.getShowOnConfigurator().booleanValue()) {
            indicator.setHidden(Boolean.valueOf(false));
            this.setContextToJsonField(creator, indicator);
        } else {
            indicator.setHidden(Boolean.valueOf(true));
        }
        if (metaField.getTypeName().equals("BigDecimal")) {
            indicator.setPrecision(Integer.valueOf(20));
            indicator.setScale(Integer.valueOf(scale));
        } else if (!Strings.isNullOrEmpty((String)metaField.getRelationship())) {
            indicator.setTargetModel(((MetaModelRepository)Beans.get(MetaModelRepository.class)).findByName(metaField.getTypeName()).getFullName());
        }
    }

    @Override
    public String getConfiguratorCreatorDomain() {
        User user = AuthUtils.getUser();
        Group group = user.getGroup();
        List configuratorCreatorList = this.configuratorCreatorRepo.all().filter("self.isActive = true").fetch();
        if (configuratorCreatorList == null || configuratorCreatorList.isEmpty()) {
            return "self.id in (0)";
        }
        configuratorCreatorList.removeIf(creator -> !creator.getAuthorizedUserSet().contains((Object)user) && !creator.getAuthorizedGroupSet().contains((Object)group));
        return "self.id in (" + StringTool.getIdListString((Collection)configuratorCreatorList) + ")";
    }

    @Override
    @Transactional
    public void init(ConfiguratorCreator creator) {
        creator.addAuthorizedUserSetItem(AuthUtils.getUser());
        this.addRequiredFormulas(creator);
    }

    @Override
    @Transactional
    public void addRequiredFormulas(ConfiguratorCreator creator) {
        for (Field field : Product.class.getDeclaredFields()) {
            if (field.getAnnotation(NotNull.class) == null) continue;
            creator.addConfiguratorProductFormulaListItem(this.createProductFormula(field.getName()));
        }
        for (Field field : SaleOrderLine.class.getDeclaredFields()) {
            if (field.getAnnotation(NotNull.class) == null) continue;
            creator.addConfiguratorSOLineFormulaListItem(this.createSOLineFormula(field.getName()));
        }
    }

    protected ConfiguratorProductFormula createProductFormula(String name) {
        ConfiguratorProductFormula configuratorProductFormula = new ConfiguratorProductFormula();
        this.completeFormula(configuratorProductFormula, name, "Product");
        return configuratorProductFormula;
    }

    protected ConfiguratorSOLineFormula createSOLineFormula(String name) {
        ConfiguratorSOLineFormula configuratorSOLineFormula = new ConfiguratorSOLineFormula();
        this.completeFormula(configuratorSOLineFormula, name, "SaleOrderLine");
        return configuratorSOLineFormula;
    }

    protected void completeFormula(ConfiguratorFormula configuratorFormula, String name, String metaFieldType) {
        configuratorFormula.setShowOnConfigurator(true);
        configuratorFormula.setFormula("");
        Long modelId = ((MetaModel)JPA.all(MetaModel.class).filter("self.name = ?", new Object[]{metaFieldType}).fetchOne()).getId();
        MetaField metaField = (MetaField)((Object)JPA.all(MetaField.class).filter("self.name = ? AND self.metaModel.id = ?", new Object[]{name, modelId}).fetchOne());
        configuratorFormula.setMetaField(metaField);
    }

    @Override
    @Transactional
    public void activate(ConfiguratorCreator creator) {
        creator.setIsActive(true);
    }

    protected void setContextToJsonField(ConfiguratorCreator creator, MetaJsonField field) {
        Class<?> modelClass;
        String fieldName = "configuratorCreator";
        String modelName = field.getModel();
        try {
            modelClass = Class.forName(modelName);
        }
        catch (ClassNotFoundException e) {
            TraceBackService.trace((Throwable)e);
            return;
        }
        Mapper mapper = Mapper.of(modelClass);
        Property property = mapper.getProperty("configuratorCreator");
        String target = property == null ? null : property.getTarget().getName();
        String targetName = property == null ? null : property.getTargetName();
        field.setContextField("configuratorCreator");
        field.setContextFieldTarget(target);
        field.setContextFieldTargetName(targetName);
        field.setContextFieldValue(creator.getId().toString());
        field.setContextFieldTitle(creator.getName());
    }
}

