/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.service.configurator;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.sale.db.Configurator;
import com.axelor.apps.sale.db.ConfiguratorCreator;
import com.axelor.apps.sale.db.ConfiguratorFormula;
import com.axelor.apps.sale.db.ConfiguratorSOLineFormula;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderLineRepository;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.configurator.ConfiguratorFormulaService;
import com.axelor.apps.sale.service.configurator.ConfiguratorService;
import com.axelor.apps.sale.service.saleorder.SaleOrderComputeService;
import com.axelor.apps.sale.service.saleorder.SaleOrderLineService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaSelectItem;
import com.axelor.meta.db.repo.MetaFieldRepository;
import com.axelor.meta.db.repo.MetaSelectItemRepository;
import com.axelor.rpc.JsonContext;
import com.axelor.script.GroovyScriptHelper;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import groovy.lang.MissingPropertyException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;

public class ConfiguratorServiceImpl
implements ConfiguratorService {
    protected AppBaseService appBaseService;

    @Inject
    public ConfiguratorServiceImpl(AppBaseService appBaseService) {
        this.appBaseService = appBaseService;
    }

    @Override
    public void updateIndicators(Configurator configurator, JsonContext jsonAttributes, JsonContext jsonIndicators) throws AxelorException {
        if (configurator.getConfiguratorCreator() == null) {
            return;
        }
        List<MetaJsonField> indicators = configurator.getConfiguratorCreator().getIndicators();
        for (MetaJsonField indicator : indicators) {
            try {
                Object calculatedValue = this.computeIndicatorValue(configurator, indicator.getName(), jsonAttributes);
                this.checkType(calculatedValue, indicator);
                jsonIndicators.put(indicator.getName(), calculatedValue);
            }
            catch (MissingPropertyException e) {}
        }
    }

    @Override
    public void checkType(Object calculatedValue, MetaJsonField indicator) throws AxelorException {
        String wantedClassName;
        if (calculatedValue == null) {
            return;
        }
        String wantedType = this.jsonTypeToType(indicator.getType());
        String calculatedValueClassName = ((ConfiguratorFormulaService)Beans.get(ConfiguratorFormulaService.class)).getCalculatedClassName(calculatedValue);
        if (wantedType.equals("ManyToOne") || wantedType.equals("ManyToMany") || wantedType.equals("OneToMany") || wantedType.equals("Custom-ManyToOne") || wantedType.equals("Custom-ManyToMany") || wantedType.equals("Custom-OneToMany")) {
            String targetName = indicator.getTargetModel();
            wantedClassName = targetName.substring(targetName.lastIndexOf(46) + 1);
        } else {
            wantedClassName = wantedType;
        }
        if (!this.areCompatible(wantedClassName, calculatedValueClassName)) {
            throw new AxelorException(4, I18n.get((String)"The field %s is of type %s, but the configured script returned value is of type %s."), new Object[]{indicator.getName().substring(0, indicator.getName().indexOf(95)), wantedClassName, calculatedValueClassName});
        }
    }

    protected String jsonTypeToType(String nameType) {
        MetaSelectItem item = (MetaSelectItem)((MetaSelectItemRepository)Beans.get(MetaSelectItemRepository.class)).all().filter("self.select.name = :_jsonFieldType AND self.value = :_value").bind("_jsonFieldType", (Object)"json.field.type").bind("_value", (Object)nameType).fetchOne();
        if (item == null) {
            return "";
        }
        return item.getTitle().equals("Decimal") ? "BigDecimal" : item.getTitle();
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void generate(Configurator configurator, JsonContext jsonAttributes, JsonContext jsonIndicators) throws AxelorException {
        this.generateProduct(configurator, jsonAttributes, jsonIndicators);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void generateProduct(Configurator configurator, JsonContext jsonAttributes, JsonContext jsonIndicators) throws AxelorException {
        this.cleanIndicators(jsonIndicators);
        Mapper mapper = Mapper.of(Product.class);
        Product product = new Product();
        for (String key : jsonIndicators.keySet()) {
            mapper.set((Object)product, key, jsonIndicators.get((Object)key));
        }
        this.fixRelationalFields((Model)((Object)product));
        if (product.getProductTypeSelect() == null) {
            product.setProductTypeSelect("storable");
        }
        if (product.getCode() == null) {
            throw new AxelorException((Model)((Object)configurator), 1, I18n.get((String)"You must configure a script to fill the created product code."));
        }
        if (product.getName() == null) {
            throw new AxelorException((Model)((Object)configurator), 1, I18n.get((String)"You must configure a script to fill the created product name."));
        }
        configurator.setProduct(product);
        product.setConfigurator(configurator);
        ((ProductRepository)((Object)Beans.get(ProductRepository.class))).save((Model)((Object)product));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void addLineToSaleOrder(Configurator configurator, SaleOrder saleOrder, JsonContext jsonAttributes, JsonContext jsonIndicators) throws AxelorException {
        if (configurator.getConfiguratorCreator().getGenerateProduct().booleanValue()) {
            SaleOrderLine saleOrderLine = new SaleOrderLine();
            saleOrderLine.setSaleOrder(saleOrder);
            this.generate(configurator, jsonAttributes, jsonIndicators);
            saleOrderLine.setProduct(configurator.getProduct());
            this.fillSaleOrderWithProduct(saleOrderLine);
            ((SaleOrderLineService)Beans.get(SaleOrderLineService.class)).computeValues(saleOrderLine.getSaleOrder(), saleOrderLine);
            ((SaleOrderLineRepository)((Object)Beans.get(SaleOrderLineRepository.class))).save((Model)((Object)saleOrderLine));
        } else {
            this.generateSaleOrderLine(configurator, jsonAttributes, jsonIndicators, saleOrder);
        }
        ((SaleOrderComputeService)Beans.get(SaleOrderComputeService.class)).computeSaleOrder(saleOrder);
        ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).save((Model)((Object)saleOrder));
    }

    protected void fillSaleOrderWithProduct(SaleOrderLine saleOrderLine) throws AxelorException {
        SaleOrderLineService saleOrderLineService = (SaleOrderLineService)Beans.get(SaleOrderLineService.class);
        if (saleOrderLine.getProduct() != null) {
            saleOrderLineService.computeProductInformation(saleOrderLine, saleOrderLine.getSaleOrder());
        }
    }

    protected void overwriteFieldToUpdate(Configurator configurator, SaleOrderLine saleOrderLine, JsonContext attributes) throws AxelorException {
        List<ConfiguratorSOLineFormula> formulas = configurator.getConfiguratorCreator().getConfiguratorSOLineFormulaList();
        if (formulas != null) {
            Mapper mapper = Mapper.of(SaleOrderLine.class);
            for (ConfiguratorSOLineFormula formula : formulas) {
                if (formula.getUpdateFromSelect() != 1) continue;
                Object valueToUpdate = this.computeIndicatorValue(configurator, formula.getMetaField().getName() + "_1", attributes);
                if ("ManyToOne".equals(formula.getMetaField().getRelationship())) {
                    this.fixRelationalField((Model)((Object)saleOrderLine), (Model)valueToUpdate, formula.getMetaField());
                    continue;
                }
                mapper.set((Object)saleOrderLine, formula.getMetaField().getName(), valueToUpdate);
            }
        }
    }

    protected Object computeIndicatorValue(Configurator configurator, String indicatorName, JsonContext jsonAttributes) {
        ConfiguratorCreator creator = configurator.getConfiguratorCreator();
        List<ConfiguratorFormula> formulas = creator.getGenerateProduct() != false ? creator.getConfiguratorProductFormulaList() : creator.getConfiguratorSOLineFormulaList();
        String groovyFormula = null;
        for (ConfiguratorFormula formula : formulas) {
            String fieldName = indicatorName;
            fieldName = fieldName.substring(0, fieldName.indexOf(95));
            MetaField metaField = formula.getMetaField();
            if (!metaField.getName().equals(fieldName)) continue;
            groovyFormula = formula.getFormula();
            break;
        }
        if (groovyFormula == null || jsonAttributes == null) {
            return null;
        }
        return this.computeFormula(groovyFormula, jsonAttributes);
    }

    @Override
    public Object computeFormula(String groovyFormula, JsonContext values) {
        User currentUser = AuthUtils.getUser();
        Company company = currentUser != null ? currentUser.getActiveCompany() : null;
        values.put("__user__", (Object)currentUser);
        values.put("__date__", (Object)this.appBaseService.getTodayDate(company));
        values.put("__datetime__", (Object)this.appBaseService.getTodayDateTime(company));
        GroovyScriptHelper scriptHelper = new GroovyScriptHelper((Bindings)values);
        return scriptHelper.eval(groovyFormula);
    }

    @Override
    public boolean areCompatible(String targetClassName, String fromClassName) {
        return targetClassName.equals(fromClassName) || targetClassName.equals("BigDecimal") && fromClassName.equals("Integer") || targetClassName.equals("BigDecimal") && fromClassName.equals("String") || targetClassName.equals("String") && fromClassName.equals("GStringImpl");
    }

    protected SaleOrderLine generateSaleOrderLine(Configurator configurator, JsonContext jsonAttributes, JsonContext jsonIndicators, SaleOrder saleOrder) throws AxelorException {
        this.cleanIndicators(jsonIndicators);
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)Mapper.toBean(SaleOrderLine.class, (Map)jsonIndicators));
        saleOrderLine.setSaleOrder(saleOrder);
        this.fixRelationalFields((Model)((Object)saleOrderLine));
        this.fillSaleOrderWithProduct(saleOrderLine);
        this.overwriteFieldToUpdate(configurator, saleOrderLine, jsonAttributes);
        if (saleOrderLine.getProductName() == null) {
            throw new AxelorException((Model)((Object)configurator), 1, I18n.get((String)"You must configure a script to fill the product name in the created sale order line."));
        }
        saleOrderLine = (SaleOrderLine)((Object)((SaleOrderLineRepository)((Object)Beans.get(SaleOrderLineRepository.class))).save((Model)((Object)saleOrderLine)));
        ((SaleOrderLineService)Beans.get(SaleOrderLineService.class)).computeValues(saleOrderLine.getSaleOrder(), saleOrderLine);
        return saleOrderLine;
    }

    protected void cleanIndicators(JsonContext jsonIndicators) {
        HashMap newKeyMap = new HashMap();
        for (Map.Entry entry : jsonIndicators.entrySet()) {
            String oldKey = entry.getKey().toString();
            newKeyMap.put(oldKey.substring(0, oldKey.indexOf(95)), entry.getValue());
        }
        jsonIndicators.clear();
        jsonIndicators.putAll(newKeyMap);
    }

    protected void fixRelationalFields(Model model) throws AxelorException {
        List manyToOneFields = ((MetaFieldRepository)((Object)Beans.get(MetaFieldRepository.class))).all().filter("self.metaModel.name = :name AND self.relationship = 'ManyToOne'").bind("name", (Object)model.getClass().getSimpleName()).fetch();
        Mapper mapper = Mapper.of(model.getClass());
        for (MetaField manyToOneField : manyToOneFields) {
            Model manyToOneValue = (Model)mapper.get((Object)model, manyToOneField.getName());
            this.fixRelationalField(model, manyToOneValue, manyToOneField);
        }
    }

    protected void fixRelationalField(Model parentModel, Model value, MetaField metaField) throws AxelorException {
        if (value != null) {
            Mapper mapper = Mapper.of(parentModel.getClass());
            try {
                String className = String.format("%s.%s", metaField.getPackageName(), metaField.getTypeName());
                Model manyToOneDbValue = JPA.find(Class.forName(className), (Long)value.getId());
                mapper.set((Object)parentModel, metaField.getName(), (Object)manyToOneDbValue);
            }
            catch (Exception e) {
                throw new AxelorException(Configurator.class, 4, e.getMessage());
            }
        }
    }
}

