/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.service.saleorder;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.base.service.CurrencyConversionService;
import com.axelor.apps.base.service.DurationService;
import com.axelor.apps.sale.db.Pack;
import com.axelor.apps.sale.db.PackLine;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.app.AppSaleService;
import com.axelor.apps.sale.service.saleorder.SaleOrderComputeService;
import com.axelor.apps.sale.service.saleorder.SaleOrderLineService;
import com.axelor.apps.sale.service.saleorder.SaleOrderMarginService;
import com.axelor.apps.sale.service.saleorder.SaleOrderService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wslite.json.JSONException;

public class SaleOrderServiceImpl
implements SaleOrderService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private SaleOrderLineService saleOrderService;

    @Override
    public String getFileName(SaleOrder saleOrder) {
        String prefixFileName = I18n.get((String)"Sale order");
        if (saleOrder.getStatusSelect() == 1 || saleOrder.getStatusSelect() == 2) {
            prefixFileName = I18n.get((String)"Sale quotation");
        }
        return prefixFileName + " " + saleOrder.getSaleOrderSeq() + (((AppSaleService)Beans.get(AppSaleService.class)).getAppSale().getManageSaleOrderVersion() != false && saleOrder.getVersionNumber() > 1 ? "-V" + saleOrder.getVersionNumber() : "");
    }

    @Override
    public SaleOrder computeEndOfValidityDate(SaleOrder saleOrder) {
        Company company = saleOrder.getCompany();
        if (saleOrder.getDuration() == null && company != null && company.getSaleConfig() != null) {
            saleOrder.setDuration(company.getSaleConfig().getDefaultValidityDuration());
        }
        if (saleOrder.getCreationDate() != null) {
            saleOrder.setEndOfValidityDate(((DurationService)Beans.get(DurationService.class)).computeDuration(saleOrder.getDuration(), saleOrder.getCreationDate()));
        }
        return saleOrder;
    }

    @Override
    @Deprecated
    public String getReportLink(SaleOrder saleOrder, String name, String language, boolean proforma, String format) throws AxelorException {
        return ReportFactory.createReport((String)"SaleOrder.rptdesign", (String)(name + "-${date}")).addParam("Locale", (Object)language).addParam("Timezone", saleOrder.getCompany() != null ? saleOrder.getCompany().getTimezone() : null).addParam("SaleOrderId", (Object)saleOrder.getId()).addParam("ProformaInvoice", (Object)proforma).addFormat(format).generate().getFileLink();
    }

    @Override
    public void computeAddressStr(SaleOrder saleOrder) {
        AddressService addressService = (AddressService)Beans.get(AddressService.class);
        saleOrder.setMainInvoicingAddressStr(addressService.computeAddressStr(saleOrder.getMainInvoicingAddress()));
        saleOrder.setDeliveryAddressStr(addressService.computeAddressStr(saleOrder.getDeliveryAddress()));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public boolean enableEditOrder(SaleOrder saleOrder) throws AxelorException {
        if (saleOrder.getStatusSelect() == 4) {
            throw new AxelorException((Model)((Object)saleOrder), 5, I18n.get((String)"This sale order is completed."));
        }
        saleOrder.setOrderBeingEdited(true);
        return false;
    }

    @Override
    public void checkModifiedConfirmedOrder(SaleOrder saleOrder, SaleOrder saleOrderView) throws AxelorException {
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validateChanges(SaleOrder saleOrder) throws AxelorException {
    }

    @Override
    public void sortSaleOrderLineList(SaleOrder saleOrder) {
        if (saleOrder.getSaleOrderLineList() != null) {
            saleOrder.getSaleOrderLineList().sort(Comparator.comparing(SaleOrderLine::getSequence));
        }
    }

    @Override
    @Transactional
    public SaleOrder addPack(SaleOrder saleOrder, Pack pack, BigDecimal packQty) {
        Integer sequence = 0;
        List<SaleOrderLine> soLines = saleOrder.getSaleOrderLineList();
        if (soLines != null && !soLines.isEmpty()) {
            sequence = (Integer)Collections.max(soLines.stream().map(soLine -> soLine.getSequence()).collect(Collectors.toSet()));
        }
        BigDecimal ConversionRate = new BigDecimal(1.0);
        if (pack.getCurrency() != null && !pack.getCurrency().getCode().equals(saleOrder.getCurrency().getCode())) {
            try {
                ConversionRate = ((CurrencyConversionService)Beans.get(CurrencyConversionService.class)).convert(pack.getCurrency(), saleOrder.getCurrency());
            }
            catch (AxelorException | MalformedURLException | JSONException e) {
                TraceBackService.trace((Throwable)e);
            }
        }
        for (PackLine packLine : pack.getComponents()) {
            SaleOrderLine soLine2 = this.saleOrderService.createSaleOrderLine(packLine, saleOrder, packQty, ConversionRate, sequence = Integer.valueOf(sequence + 1));
            if (soLine2 == null) continue;
            soLine2.setSaleOrder(saleOrder);
            soLines.add(soLine2);
        }
        if (soLines != null && !soLines.isEmpty()) {
            try {
                saleOrder = ((SaleOrderComputeService)Beans.get(SaleOrderComputeService.class)).computeSaleOrder(saleOrder);
                ((SaleOrderMarginService)Beans.get(SaleOrderMarginService.class)).computeMarginSaleOrder(saleOrder);
            }
            catch (AxelorException e) {
                TraceBackService.trace((AxelorException)e);
            }
            ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).save((Model)((Object)saleOrder));
        }
        return saleOrder;
    }
}

