/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.service.saleorder;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Blocking;
import com.axelor.apps.base.db.CancelReason;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.BlockingRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.crm.db.Opportunity;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.exception.BlockedSaleOrderException;
import com.axelor.apps.sale.service.app.AppSaleService;
import com.axelor.apps.sale.service.saleorder.SaleOrderWorkflowService;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import javax.persistence.Query;

public class SaleOrderWorkflowServiceImpl
implements SaleOrderWorkflowService {
    protected SequenceService sequenceService;
    protected PartnerRepository partnerRepo;
    protected SaleOrderRepository saleOrderRepo;
    protected AppSaleService appSaleService;
    protected UserService userService;

    @Inject
    public SaleOrderWorkflowServiceImpl(SequenceService sequenceService, PartnerRepository partnerRepo, SaleOrderRepository saleOrderRepo, AppSaleService appSaleService, UserService userService) {
        this.sequenceService = sequenceService;
        this.partnerRepo = partnerRepo;
        this.saleOrderRepo = saleOrderRepo;
        this.appSaleService = appSaleService;
        this.userService = userService;
    }

    @Override
    @Transactional
    public Partner validateCustomer(SaleOrder saleOrder) {
        Partner clientPartner = (Partner)((Object)this.partnerRepo.find(saleOrder.getClientPartner().getId()));
        clientPartner.setIsCustomer(true);
        clientPartner.setIsProspect(false);
        return (Partner)((Object)this.partnerRepo.save((Model)((Object)clientPartner)));
    }

    @Override
    public String getSequence(Company company) throws AxelorException {
        String seq = this.sequenceService.getSequenceNumber("saleOrder", company);
        if (seq == null) {
            throw new AxelorException((Model)((Object)company), 4, I18n.get((String)"The company %s doesn't have any configured sequence for sale orders"), new Object[]{company.getName()});
        }
        return seq;
    }

    @Override
    @Transactional
    public void cancelSaleOrder(SaleOrder saleOrder, CancelReason cancelReason, String cancelReasonStr) {
        Query q = JPA.em().createQuery("select count(*) FROM SaleOrder as self WHERE self.statusSelect in (?1 , ?2) AND self.clientPartner = ?3 ");
        q.setParameter(1, (Object)3);
        q.setParameter(2, (Object)4);
        q.setParameter(3, (Object)saleOrder.getClientPartner());
        if ((Long)q.getSingleResult() == 0L) {
            saleOrder.getClientPartner().setIsCustomer(false);
            saleOrder.getClientPartner().setIsProspect(true);
        }
        saleOrder.setStatusSelect(5);
        saleOrder.setCancelReason(cancelReason);
        if (Strings.isNullOrEmpty((String)cancelReasonStr)) {
            saleOrder.setCancelReasonStr(cancelReason.getName());
        } else {
            saleOrder.setCancelReasonStr(cancelReasonStr);
        }
        this.saleOrderRepo.save((Model)((Object)saleOrder));
    }

    @Override
    @Transactional(rollbackOn={Exception.class}, ignore={BlockedSaleOrderException.class})
    public void finalizeQuotation(SaleOrder saleOrder) throws AxelorException {
        Partner partner = saleOrder.getClientPartner();
        Blocking blocking = ((BlockingService)Beans.get(BlockingService.class)).getBlocking(partner, saleOrder.getCompany(), BlockingRepository.SALE_BLOCKING.intValue());
        if (blocking != null) {
            saleOrder.setBlockedOnCustCreditExceed(true);
            if (!saleOrder.getManualUnblock().booleanValue()) {
                this.saleOrderRepo.save((Model)((Object)saleOrder));
                String reason = blocking.getBlockingReason() != null ? blocking.getBlockingReason().getName() : "";
                throw new BlockedSaleOrderException((Model)((Object)partner), I18n.get((String)"Client is sale blocked:") + " " + reason);
            }
        }
        if (saleOrder.getVersionNumber() == 1 && this.sequenceService.isEmptyOrDraftSequenceNumber(saleOrder.getSaleOrderSeq())) {
            saleOrder.setSaleOrderSeq(this.getSequence(saleOrder.getCompany()));
        }
        saleOrder.setStatusSelect(2);
        if (this.appSaleService.getAppSale().getPrintingOnSOFinalization().booleanValue()) {
            this.saveSaleOrderPDFAsAttachment(saleOrder);
        }
        this.saleOrderRepo.save((Model)((Object)saleOrder));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void confirmSaleOrder(SaleOrder saleOrder) throws AxelorException {
        Opportunity opportunity;
        saleOrder.setStatusSelect(3);
        saleOrder.setConfirmationDateTime(this.appSaleService.getTodayDateTime().toLocalDateTime());
        saleOrder.setConfirmedByUser(this.userService.getUser());
        this.validateCustomer(saleOrder);
        if (this.appSaleService.getAppSale().getCloseOpportunityUponSaleOrderConfirmation().booleanValue() && (opportunity = saleOrder.getOpportunity()) != null) {
            opportunity.setSalesStageSelect(5);
        }
        this.saleOrderRepo.save((Model)((Object)saleOrder));
    }

    @Transactional
    public void completeSaleOrder(SaleOrder saleOrder) throws AxelorException {
        saleOrder.setStatusSelect(4);
        saleOrder.setOrderBeingEdited(false);
        this.saleOrderRepo.save((Model)((Object)saleOrder));
    }

    @Override
    public void saveSaleOrderPDFAsAttachment(SaleOrder saleOrder) throws AxelorException {
        if (saleOrder.getPrintingSettings() == null) {
            if (saleOrder.getCompany().getPrintingSettings() != null) {
                saleOrder.setPrintingSettings(saleOrder.getCompany().getPrintingSettings());
            } else {
                throw new AxelorException(1, String.format(I18n.get((String)"Please fill printing settings on sale order %s."), saleOrder.getSaleOrderSeq()), new Object[]{saleOrder});
            }
        }
        ReportFactory.createReport((String)"SaleOrder.rptdesign", (String)(this.getFileName(saleOrder) + "-${date}")).addParam("Locale", (Object)ReportSettings.getPrintingLocale((Partner)saleOrder.getClientPartner())).addParam("Timezone", saleOrder.getCompany() != null ? saleOrder.getCompany().getTimezone() : null).addParam("SaleOrderId", (Object)saleOrder.getId()).addParam("HeaderHeight", (Object)saleOrder.getPrintingSettings().getPdfHeaderHeight()).addParam("FooterHeight", (Object)saleOrder.getPrintingSettings().getPdfFooterHeight()).toAttach((Model)((Object)saleOrder)).generate().getFileLink();
    }

    @Override
    public String getFileName(SaleOrder saleOrder) {
        String fileNamePrefix = saleOrder.getStatusSelect() == 1 || saleOrder.getStatusSelect() == 2 ? "Sale quotation" : "Sale order";
        return I18n.get((String)fileNamePrefix) + " " + saleOrder.getSaleOrderSeq() + (saleOrder.getVersionNumber() > 1 ? "-V" + saleOrder.getVersionNumber() : "");
    }
}

