/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.service.saleorder.print;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.app.AppSaleService;
import com.axelor.apps.sale.service.saleorder.SaleOrderService;
import com.axelor.apps.sale.service.saleorder.print.SaleOrderPrintService;
import com.axelor.apps.tool.ModelTool;
import com.axelor.apps.tool.ThrowConsumer;
import com.axelor.apps.tool.file.PdfTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SaleOrderPrintServiceImpl
implements SaleOrderPrintService {
    @Inject
    protected SaleOrderService saleOrderService;
    protected AppSaleService appSaleService;

    @Inject
    public SaleOrderPrintServiceImpl(AppSaleService appSaleService) {
        this.appSaleService = appSaleService;
    }

    @Override
    public String printSaleOrder(SaleOrder saleOrder, boolean proforma, String format) throws AxelorException, IOException {
        String fileName = this.saleOrderService.getFileName(saleOrder) + "." + format;
        return PdfTool.getFileLinkFromPdfFile((File)this.print(saleOrder, proforma, format), (String)fileName);
    }

    @Override
    public String printSaleOrders(List<Long> ids) throws IOException {
        final ArrayList printedSaleOrders = new ArrayList();
        ModelTool.apply(SaleOrder.class, ids, (ThrowConsumer)new ThrowConsumer<SaleOrder>(){

            public void accept(SaleOrder saleOrder) throws Exception {
                printedSaleOrders.add(SaleOrderPrintServiceImpl.this.print(saleOrder, false, "pdf"));
            }
        });
        Integer status = ((SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(ids.get(0)))).getStatusSelect();
        String fileName = this.getSaleOrderFilesName(status);
        return PdfTool.mergePdfToFileLink(printedSaleOrders, (String)fileName);
    }

    @Override
    public File print(SaleOrder saleOrder, boolean proforma, String format) throws AxelorException {
        ReportSettings reportSettings = this.prepareReportSettings(saleOrder, proforma, format);
        return reportSettings.generate().getFile();
    }

    @Override
    public ReportSettings prepareReportSettings(SaleOrder saleOrder, boolean proforma, String format) throws AxelorException {
        if (saleOrder.getPrintingSettings() == null) {
            if (saleOrder.getCompany().getPrintingSettings() != null) {
                saleOrder.setPrintingSettings(saleOrder.getCompany().getPrintingSettings());
            } else {
                throw new AxelorException(1, String.format(I18n.get((String)"Please fill printing settings on sale order %s."), saleOrder.getSaleOrderSeq()), new Object[]{saleOrder});
            }
        }
        String locale = ReportSettings.getPrintingLocale((Partner)saleOrder.getClientPartner());
        String title = this.saleOrderService.getFileName(saleOrder);
        ReportSettings reportSetting = ReportFactory.createReport((String)"SaleOrder.rptdesign", (String)(title + " - ${date}"));
        return reportSetting.addParam("SaleOrderId", (Object)saleOrder.getId()).addParam("Timezone", saleOrder.getCompany() != null ? saleOrder.getCompany().getTimezone() : null).addParam("Locale", (Object)locale).addParam("ProformaInvoice", (Object)proforma).addParam("HeaderHeight", (Object)saleOrder.getPrintingSettings().getPdfHeaderHeight()).addParam("FooterHeight", (Object)saleOrder.getPrintingSettings().getPdfFooterHeight()).addFormat(format);
    }

    protected String getSaleOrderFilesName(Integer status) {
        String prefixFileName = I18n.get((String)"Sale orders");
        if (status == 1 || status == 2) {
            prefixFileName = I18n.get((String)"Sale quotations");
        }
        return prefixFileName + " - " + ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate((Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)).format(DateTimeFormatter.BASIC_ISO_DATE) + "." + "pdf";
    }
}

