/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.web;

import com.axelor.apps.sale.db.ConfiguratorCreator;
import com.axelor.apps.sale.db.repo.ConfiguratorCreatorRepository;
import com.axelor.apps.sale.service.configurator.ConfiguratorCreatorImportService;
import com.axelor.apps.sale.service.configurator.ConfiguratorCreatorService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfiguratorCreatorController {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void updateAndActivate(ActionRequest request, ActionResponse response) {
        try {
            ConfiguratorCreator creator = (ConfiguratorCreator)((Object)request.getContext().asType(ConfiguratorCreator.class));
            ConfiguratorCreatorService configuratorCreatorService = (ConfiguratorCreatorService)Beans.get(ConfiguratorCreatorService.class);
            creator = (ConfiguratorCreator)((Object)((ConfiguratorCreatorRepository)((Object)Beans.get(ConfiguratorCreatorRepository.class))).find(creator.getId()));
            configuratorCreatorService.updateIndicators(creator);
            configuratorCreatorService.activate(creator);
            response.setSignal("refresh-app", (Object)true);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    public void importConfiguratorCreators(ActionRequest request, ActionResponse response) {
        try {
            String pathDiff = (String)((Map)request.getContext().get((Object)"dataFile")).get("filePath");
            String importLog = ((ConfiguratorCreatorImportService)Beans.get(ConfiguratorCreatorImportService.class)).importConfiguratorCreators(pathDiff);
            response.setValue("importLog", (Object)importLog);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    public void updateAttributes(ActionRequest request, ActionResponse response) {
        try {
            ConfiguratorCreator creator = (ConfiguratorCreator)((Object)request.getContext().asType(ConfiguratorCreator.class));
            creator = (ConfiguratorCreator)((Object)((ConfiguratorCreatorRepository)((Object)Beans.get(ConfiguratorCreatorRepository.class))).find(creator.getId()));
            ((ConfiguratorCreatorService)Beans.get(ConfiguratorCreatorService.class)).updateAttributes(creator);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }
}

