/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderManagementRepository;
import com.axelor.apps.sale.service.saleorder.SaleOrderComputeService;
import com.axelor.apps.sale.service.saleorder.SaleOrderService;
import com.axelor.apps.sale.service.saleorder.SaleOrderWorkflowService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import java.util.Map;

public class ImportSaleOrder {
    @Inject
    SaleOrderManagementRepository saleOrderRepo;
    protected SaleOrderService saleOrderService;
    protected SaleOrderComputeService saleOrderComputeService;
    protected SaleOrderWorkflowService saleOrderWorkflowService;
    protected SequenceService sequenceService;

    @Inject
    public ImportSaleOrder(SaleOrderService saleOrderService, SaleOrderComputeService saleOrderComputeService, SaleOrderWorkflowService saleOrderWorkflowService, SequenceService sequenceService) {
        this.saleOrderService = saleOrderService;
        this.saleOrderComputeService = saleOrderComputeService;
        this.saleOrderWorkflowService = saleOrderWorkflowService;
        this.sequenceService = sequenceService;
    }

    public Object importSaleOrder(Object bean, Map<String, Object> values) throws AxelorException {
        assert (bean instanceof SaleOrder);
        SaleOrder saleOrder = (SaleOrder)((Object)bean);
        this.saleOrderService.computeAddressStr(saleOrder);
        saleOrder = this.saleOrderComputeService.computeSaleOrder(saleOrder);
        if (saleOrder.getStatusSelect() == 1) {
            saleOrder.setSaleOrderSeq(this.sequenceService.getDraftSequenceNumber((Model)((Object)saleOrder)));
            this.saleOrderRepo.computeFullName(saleOrder);
        } else {
            this.saleOrderWorkflowService.finalizeQuotation(saleOrder);
        }
        return saleOrder;
    }
}

