/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web;

import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.service.MapService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/map")
public class MapRestSale {
    @Inject
    MapService mapService;
    @Inject
    private SaleOrderRepository saleOrderRepo;

    @Path(value="/geomap/turnover")
    @GET
    @Produces(value={"application/json"})
    public JsonNode getGeoMapData() {
        HashMap<String, BigDecimal> data = new HashMap<String, BigDecimal>();
        List orders = this.saleOrderRepo.all().filter("self.statusSelect=?", new Object[]{3}).fetch();
        JsonNodeFactory factory = JsonNodeFactory.instance;
        ObjectNode mainNode = factory.objectNode();
        ArrayNode arrayNode = factory.arrayNode();
        ArrayNode labelNode = factory.arrayNode();
        labelNode.add("Country");
        labelNode.add("Turnover");
        arrayNode.add((JsonNode)labelNode);
        for (SaleOrder so : orders) {
            Country country = so.getMainInvoicingAddress().getAddressL7Country();
            BigDecimal value = so.getExTaxTotal();
            if (country == null) continue;
            String key = country.getName();
            if (data.containsKey(key)) {
                BigDecimal oldValue = (BigDecimal)data.get(key);
                oldValue = oldValue.add(value);
                data.put(key, oldValue);
                continue;
            }
            data.put(key, value);
        }
        for (String key : data.keySet()) {
            ArrayNode dataNode = factory.arrayNode();
            dataNode.add(key);
            dataNode.add((BigDecimal)data.get(key));
            arrayNode.add((JsonNode)dataNode);
        }
        mainNode.put("status", 0);
        mainNode.set("data", (JsonNode)arrayNode);
        return mainNode;
    }
}

