/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_PAYMENT_MODE", indexes={@Index(columnList="code")})
public class PaymentMode
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_PAYMENT_MODE_SEQ")
    @SequenceGenerator(name="ACCOUNT_PAYMENT_MODE_SEQ", sequenceName="ACCOUNT_PAYMENT_MODE_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Label", translatable=true)
    @NotNull
    @Column(unique=true)
    private String name;
    @Widget(title="Code")
    @NotNull
    private String code;
    @Widget(title="Type", selection="iaccount.payment.mode.type.select")
    private Integer typeSelect = 0;
    @Widget(title="In / Out", selection="iaccount.payment.mode.in.out.select")
    private Integer inOutSelect = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public PaymentMode() {
    }

    public PaymentMode(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Integer getInOutSelect() {
        return this.inOutSelect == null ? 0 : this.inOutSelect;
    }

    public void setInOutSelect(Integer inOutSelect) {
        this.inOutSelect = inOutSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PaymentMode)) {
            return false;
        }
        PaymentMode other = (PaymentMode)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(127276201, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("typeSelect", (Object)this.getTypeSelect()).add("inOutSelect", (Object)this.getInOutSelect()).omitNullValues().toString();
    }
}

