/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.FiscalPosition;
import com.axelor.apps.account.db.Tax;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_TAX_EQUIV", uniqueConstraints={@UniqueConstraint(columnNames={"fiscal_position", "from_tax"})}, indexes={@Index(columnList="fiscal_position"), @Index(columnList="from_tax"), @Index(columnList="to_tax"), @Index(columnList="reverse_charge_tax")})
public class TaxEquiv
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_TAX_EQUIV_SEQ")
    @SequenceGenerator(name="ACCOUNT_TAX_EQUIV_SEQ", sequenceName="ACCOUNT_TAX_EQUIV_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Fiscal position")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FiscalPosition fiscalPosition;
    @Widget(title="Tax to replace")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Tax fromTax;
    @Widget(title="Replacement Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Tax toTax;
    @Widget(title="Specific note")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String specificNote;
    @Widget(title="Reverse Charge")
    private Boolean reverseCharge = Boolean.FALSE;
    @Widget(title="Reverse Charge Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Tax reverseChargeTax;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public FiscalPosition getFiscalPosition() {
        return this.fiscalPosition;
    }

    public void setFiscalPosition(FiscalPosition fiscalPosition) {
        this.fiscalPosition = fiscalPosition;
    }

    public Tax getFromTax() {
        return this.fromTax;
    }

    public void setFromTax(Tax fromTax) {
        this.fromTax = fromTax;
    }

    public Tax getToTax() {
        return this.toTax;
    }

    public void setToTax(Tax toTax) {
        this.toTax = toTax;
    }

    public String getSpecificNote() {
        return this.specificNote;
    }

    public void setSpecificNote(String specificNote) {
        this.specificNote = specificNote;
    }

    public Boolean getReverseCharge() {
        return this.reverseCharge == null ? Boolean.FALSE : this.reverseCharge;
    }

    public void setReverseCharge(Boolean reverseCharge) {
        this.reverseCharge = reverseCharge;
    }

    public Tax getReverseChargeTax() {
        return this.reverseChargeTax;
    }

    public void setReverseChargeTax(Tax reverseChargeTax) {
        this.reverseChargeTax = reverseChargeTax;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaxEquiv)) {
            return false;
        }
        TaxEquiv other = (TaxEquiv)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("reverseCharge", (Object)this.getReverseCharge()).omitNullValues().toString();
    }
}

