/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.FileTab;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_ADVANCED_IMPORT", indexes={@Index(columnList="name"), @Index(columnList="import_file"), @Index(columnList="attachment"), @Index(columnList="error_log")})
public class AdvancedImport
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_ADVANCED_IMPORT_SEQ")
    @SequenceGenerator(name="BASE_ADVANCED_IMPORT_SEQ", sequenceName="BASE_ADVANCED_IMPORT_SEQ", allocationSize=1)
    private Long id;
    private String name;
    @Widget(title="Status", readonly=true, selection="advanced.import.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Separator")
    @Size(max=1)
    private String fileSeparator = ";";
    @Widget(title="Data file")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile importFile;
    @Widget(title="Attachments")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile attachment;
    @Widget(title="Config included in file")
    private Boolean isConfigInFile = Boolean.FALSE;
    @Widget(title="Tab Config in file")
    private Boolean isFileTabConfigAdded = Boolean.FALSE;
    @Widget(title="Having header")
    private Boolean isHeader = Boolean.TRUE;
    @Widget(title="Validate values")
    private Boolean isValidateValue = Boolean.FALSE;
    @Widget(title="Nb of first lines to be ignore")
    private Integer nbOfFirstLineIgnore = 0;
    @Widget(title="Tabs configuration")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="advancedImport", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<FileTab> fileTabList;
    @Widget(title="Error logs")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile errorLog;
    @Widget(title="Selection language", selection="select.language")
    private String languageSelect;
    @Widget(title="File extension")
    private String fileExtension;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public AdvancedImport() {
    }

    public AdvancedImport(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public void setFileSeparator(String fileSeparator) {
        this.fileSeparator = fileSeparator;
    }

    public MetaFile getImportFile() {
        return this.importFile;
    }

    public void setImportFile(MetaFile importFile) {
        this.importFile = importFile;
    }

    public MetaFile getAttachment() {
        return this.attachment;
    }

    public void setAttachment(MetaFile attachment) {
        this.attachment = attachment;
    }

    public Boolean getIsConfigInFile() {
        return this.isConfigInFile == null ? Boolean.FALSE : this.isConfigInFile;
    }

    public void setIsConfigInFile(Boolean isConfigInFile) {
        this.isConfigInFile = isConfigInFile;
    }

    public Boolean getIsFileTabConfigAdded() {
        return this.isFileTabConfigAdded == null ? Boolean.FALSE : this.isFileTabConfigAdded;
    }

    public void setIsFileTabConfigAdded(Boolean isFileTabConfigAdded) {
        this.isFileTabConfigAdded = isFileTabConfigAdded;
    }

    public Boolean getIsHeader() {
        return this.isHeader == null ? Boolean.FALSE : this.isHeader;
    }

    public void setIsHeader(Boolean isHeader) {
        this.isHeader = isHeader;
    }

    public Boolean getIsValidateValue() {
        return this.isValidateValue == null ? Boolean.FALSE : this.isValidateValue;
    }

    public void setIsValidateValue(Boolean isValidateValue) {
        this.isValidateValue = isValidateValue;
    }

    public Integer getNbOfFirstLineIgnore() {
        return this.nbOfFirstLineIgnore == null ? 0 : this.nbOfFirstLineIgnore;
    }

    public void setNbOfFirstLineIgnore(Integer nbOfFirstLineIgnore) {
        this.nbOfFirstLineIgnore = nbOfFirstLineIgnore;
    }

    public List<FileTab> getFileTabList() {
        return this.fileTabList;
    }

    public void setFileTabList(List<FileTab> fileTabList) {
        this.fileTabList = fileTabList;
    }

    public void addFileTabListItem(FileTab item) {
        if (this.getFileTabList() == null) {
            this.setFileTabList(new ArrayList<FileTab>());
        }
        this.getFileTabList().add(item);
        item.setAdvancedImport(this);
    }

    public void removeFileTabListItem(FileTab item) {
        if (this.getFileTabList() == null) {
            return;
        }
        this.getFileTabList().remove((Object)item);
    }

    public void clearFileTabList() {
        if (this.getFileTabList() != null) {
            this.getFileTabList().clear();
        }
    }

    public MetaFile getErrorLog() {
        return this.errorLog;
    }

    public void setErrorLog(MetaFile errorLog) {
        this.errorLog = errorLog;
    }

    public String getLanguageSelect() {
        return this.languageSelect;
    }

    public void setLanguageSelect(String languageSelect) {
        this.languageSelect = languageSelect;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AdvancedImport)) {
            return false;
        }
        AdvancedImport other = (AdvancedImport)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("statusSelect", (Object)this.getStatusSelect()).add("fileSeparator", (Object)this.getFileSeparator()).add("isConfigInFile", (Object)this.getIsConfigInFile()).add("isFileTabConfigAdded", (Object)this.getIsFileTabConfigAdded()).add("isHeader", (Object)this.getIsHeader()).add("isValidateValue", (Object)this.getIsValidateValue()).add("nbOfFirstLineIgnore", (Object)this.getNbOfFirstLineIgnore()).add("languageSelect", (Object)this.getLanguageSelect()).add("fileExtension", (Object)this.getFileExtension()).omitNullValues().toString();
    }
}

