/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_BARCODE_TYPE_CONFIG", indexes={@Index(columnList="name")})
public class BarcodeTypeConfig
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_BARCODE_TYPE_CONFIG_SEQ")
    @SequenceGenerator(name="BASE_BARCODE_TYPE_CONFIG_SEQ", sequenceName="BASE_BARCODE_TYPE_CONFIG_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name", selection="base.barcode.select")
    @NotNull
    private String name;
    @Widget(title="Height(px)")
    @NotNull
    private Integer height = 0;
    @Widget(title="Width(px)")
    @NotNull
    private Integer width = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public BarcodeTypeConfig() {
    }

    public BarcodeTypeConfig(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getHeight() {
        return this.height == null ? 0 : this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getWidth() {
        return this.width == null ? 0 : this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BarcodeTypeConfig)) {
            return false;
        }
        BarcodeTypeConfig other = (BarcodeTypeConfig)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("height", (Object)this.getHeight()).add("width", (Object)this.getWidth()).omitNullValues().toString();
    }
}

