/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.ICalendar;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_CALENDAR_MANAGEMENT", indexes={@Index(columnList="parent_user"), @Index(columnList="user_id"), @Index(columnList="team")})
public class CalendarManagement
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_CALENDAR_MANAGEMENT_SEQ")
    @SequenceGenerator(name="BASE_CALENDAR_MANAGEMENT_SEQ", sequenceName="BASE_CALENDAR_MANAGEMENT_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User parentUser;
    @Widget(title="User")
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Team")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="All my calendars")
    private Boolean allCalendars = Boolean.FALSE;
    @Widget(title="My ERP calendars")
    private Boolean erpCalendars = Boolean.FALSE;
    @Widget(title="Selected imported/synchronized calendars")
    private Boolean icalCalendars = Boolean.FALSE;
    @Widget(title="Selected imported/synchronized calendars")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ICalendar> calendarSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public User getParentUser() {
        return this.parentUser;
    }

    public void setParentUser(User parentUser) {
        this.parentUser = parentUser;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Boolean getAllCalendars() {
        return this.allCalendars == null ? Boolean.FALSE : this.allCalendars;
    }

    public void setAllCalendars(Boolean allCalendars) {
        this.allCalendars = allCalendars;
    }

    public Boolean getErpCalendars() {
        return this.erpCalendars == null ? Boolean.FALSE : this.erpCalendars;
    }

    public void setErpCalendars(Boolean erpCalendars) {
        this.erpCalendars = erpCalendars;
    }

    public Boolean getIcalCalendars() {
        return this.icalCalendars == null ? Boolean.FALSE : this.icalCalendars;
    }

    public void setIcalCalendars(Boolean icalCalendars) {
        this.icalCalendars = icalCalendars;
    }

    public Set<ICalendar> getCalendarSet() {
        return this.calendarSet;
    }

    public void setCalendarSet(Set<ICalendar> calendarSet) {
        this.calendarSet = calendarSet;
    }

    public void addCalendarSetItem(ICalendar item) {
        if (this.getCalendarSet() == null) {
            this.setCalendarSet(new HashSet<ICalendar>());
        }
        this.getCalendarSet().add(item);
    }

    public void removeCalendarSetItem(ICalendar item) {
        if (this.getCalendarSet() == null) {
            return;
        }
        this.getCalendarSet().remove((Object)item);
    }

    public void clearCalendarSet() {
        if (this.getCalendarSet() != null) {
            this.getCalendarSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CalendarManagement)) {
            return false;
        }
        CalendarManagement other = (CalendarManagement)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("allCalendars", (Object)this.getAllCalendars()).add("erpCalendars", (Object)this.getErpCalendars()).add("icalCalendars", (Object)this.getIcalCalendars()).omitNullValues().toString();
    }
}

