/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Department;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_CANTON", indexes={@Index(columnList="name"), @Index(columnList="department")})
public class Canton
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_CANTON_SEQ")
    @SequenceGenerator(name="BASE_CANTON_SEQ", sequenceName="BASE_CANTON_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @HashKey
    @Widget(title="Code")
    @NotNull
    @Column(unique=true)
    private String code;
    @Widget(title="ARTMIN", selection="iterritory.artmin.select")
    private String artmin;
    @Widget(title="Nb of Inhabitants")
    private Integer inhabitantsNbr = 0;
    @Widget(title="Department")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Department department;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Canton() {
    }

    public Canton(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getArtmin() {
        return this.artmin;
    }

    public void setArtmin(String artmin) {
        this.artmin = artmin;
    }

    public Integer getInhabitantsNbr() {
        return this.inhabitantsNbr == null ? 0 : this.inhabitantsNbr;
    }

    public void setInhabitantsNbr(Integer inhabitantsNbr) {
        this.inhabitantsNbr = inhabitantsNbr;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Canton)) {
            return false;
        }
        Canton other = (Canton)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(2011126691, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("artmin", (Object)this.getArtmin()).add("inhabitantsNbr", (Object)this.getInhabitantsNbr()).omitNullValues().toString();
    }
}

