/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Canton;
import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.db.Department;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_CITY", indexes={@Index(columnList="name"), @Index(columnList="canton"), @Index(columnList="inseeCode"), @Index(columnList="department"), @Index(columnList="country")})
public class City
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_CITY_SEQ")
    @SequenceGenerator(name="BASE_CITY_SEQ", sequenceName="BASE_CITY_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Artmin", selection="iterritory.artmin.select")
    private String artmin;
    @Widget(title="Canton Code")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Canton canton;
    @Widget(title="National Code")
    private String inseeCode;
    @Widget(title="Department")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Department department;
    @Widget(title="Nb. of Inhabitants")
    private Integer nbInhCommune = 0;
    @Widget(title="Zip code")
    private String zip;
    @Widget(title="Zip On Right")
    private Boolean hasZipOnRight = Boolean.FALSE;
    @Widget(title="Country")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Country country;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public City() {
    }

    public City(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getArtmin() {
        return this.artmin;
    }

    public void setArtmin(String artmin) {
        this.artmin = artmin;
    }

    public Canton getCanton() {
        return this.canton;
    }

    public void setCanton(Canton canton) {
        this.canton = canton;
    }

    public String getInseeCode() {
        return this.inseeCode;
    }

    public void setInseeCode(String inseeCode) {
        this.inseeCode = inseeCode;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public Integer getNbInhCommune() {
        return this.nbInhCommune == null ? 0 : this.nbInhCommune;
    }

    public void setNbInhCommune(Integer nbInhCommune) {
        this.nbInhCommune = nbInhCommune;
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public Boolean getHasZipOnRight() {
        return this.hasZipOnRight == null ? Boolean.FALSE : this.hasZipOnRight;
    }

    public void setHasZipOnRight(Boolean hasZipOnRight) {
        this.hasZipOnRight = hasZipOnRight;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof City)) {
            return false;
        }
        City other = (City)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("artmin", (Object)this.getArtmin()).add("inseeCode", (Object)this.getInseeCode()).add("nbInhCommune", (Object)this.getNbInhCommune()).add("zip", (Object)this.getZip()).add("hasZipOnRight", (Object)this.getHasZipOnRight()).omitNullValues().toString();
    }
}

