/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Canton;
import com.axelor.apps.base.db.City;
import com.axelor.apps.base.db.Region;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_DEPARTMENT", uniqueConstraints={@UniqueConstraint(columnNames={"code", "name"})}, indexes={@Index(columnList="name"), @Index(columnList="code"), @Index(columnList="region")})
public class Department
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_DEPARTMENT_SEQ")
    @SequenceGenerator(name="BASE_DEPARTMENT_SEQ", sequenceName="BASE_DEPARTMENT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Department Name")
    @NotNull
    private String name;
    @Widget(title="DEPT")
    @NotNull
    private String code;
    @Widget(title="Region")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Region region;
    @Widget(title="Department city List")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="department", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<City> cityList;
    @Widget(title="Department Cantons List")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="department", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Canton> cantonList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Department() {
    }

    public Department(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public List<City> getCityList() {
        return this.cityList;
    }

    public void setCityList(List<City> cityList) {
        this.cityList = cityList;
    }

    public void addCityListItem(City item) {
        if (this.getCityList() == null) {
            this.setCityList(new ArrayList<City>());
        }
        this.getCityList().add(item);
        item.setDepartment(this);
    }

    public void removeCityListItem(City item) {
        if (this.getCityList() == null) {
            return;
        }
        this.getCityList().remove((Object)item);
    }

    public void clearCityList() {
        if (this.getCityList() != null) {
            this.getCityList().clear();
        }
    }

    public List<Canton> getCantonList() {
        return this.cantonList;
    }

    public void setCantonList(List<Canton> cantonList) {
        this.cantonList = cantonList;
    }

    public void addCantonListItem(Canton item) {
        if (this.getCantonList() == null) {
            this.setCantonList(new ArrayList<Canton>());
        }
        this.getCantonList().add(item);
        item.setDepartment(this);
    }

    public void removeCantonListItem(Canton item) {
        if (this.getCantonList() == null) {
            return;
        }
        this.getCantonList().remove((Object)item);
    }

    public void clearCantonList() {
        if (this.getCantonList() != null) {
            this.getCantonList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Department)) {
            return false;
        }
        Department other = (Department)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).omitNullValues().toString();
    }
}

