/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Country;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_ECONOMIC_AREA")
public class EconomicArea
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_ECONOMIC_AREA_SEQ")
    @SequenceGenerator(name="BASE_ECONOMIC_AREA_SEQ", sequenceName="BASE_ECONOMIC_AREA_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Column(unique=true)
    private String code;
    @HashKey
    @Widget(translatable=true)
    @Column(unique=true)
    private String name;
    @Widget(title="Countries")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="economicArea", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderBy(value="alpha2Code")
    private List<Country> countryList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public EconomicArea() {
    }

    public EconomicArea(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Country> getCountryList() {
        return this.countryList;
    }

    public void setCountryList(List<Country> countryList) {
        this.countryList = countryList;
    }

    public void addCountryListItem(Country item) {
        if (this.getCountryList() == null) {
            this.setCountryList(new ArrayList<Country>());
        }
        this.getCountryList().add(item);
        item.setEconomicArea(this);
    }

    public void removeCountryListItem(Country item) {
        if (this.getCountryList() == null) {
            return;
        }
        this.getCountryList().remove((Object)item);
        item.setEconomicArea(null);
    }

    public void clearCountryList() {
        if (this.getCountryList() != null) {
            for (Country item : this.getCountryList()) {
                item.setEconomicArea(null);
            }
            this.getCountryList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EconomicArea)) {
            return false;
        }
        EconomicArea other = (EconomicArea)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        if (!Objects.equals(this.getCode(), other.getCode())) {
            return false;
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(-1845799358, this.getCode(), this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

