/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.AdvancedImport;
import com.axelor.apps.base.db.FileField;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaModel;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_FILE_TAB", indexes={@Index(columnList="name"), @Index(columnList="meta_model"), @Index(columnList="validation_log"), @Index(columnList="advanced_import")})
public class FileTab
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_FILE_TAB_SEQ")
    @SequenceGenerator(name="BASE_FILE_TAB_SEQ", sequenceName="BASE_FILE_TAB_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Object")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModel metaModel;
    @Widget(title="Import type", selection="file.field.import.type.select")
    @Min(value=1L)
    private Integer importType = 3;
    @Widget(title="Search fields")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<FileField> searchFieldSet;
    @Widget(title="Fields configuration")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="fileTab", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<FileField> fileFieldList;
    @Widget(title="Validation log")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile validationLog;
    @Widget(title="Advanced import")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AdvancedImport advancedImport;
    @Widget(title="Actions")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String actions;
    @Widget(title="Search Call")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String searchCall;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public FileTab() {
    }

    public FileTab(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetaModel getMetaModel() {
        return this.metaModel;
    }

    public void setMetaModel(MetaModel metaModel) {
        this.metaModel = metaModel;
    }

    public Integer getImportType() {
        return this.importType == null ? 0 : this.importType;
    }

    public void setImportType(Integer importType) {
        this.importType = importType;
    }

    public Set<FileField> getSearchFieldSet() {
        return this.searchFieldSet;
    }

    public void setSearchFieldSet(Set<FileField> searchFieldSet) {
        this.searchFieldSet = searchFieldSet;
    }

    public void addSearchFieldSetItem(FileField item) {
        if (this.getSearchFieldSet() == null) {
            this.setSearchFieldSet(new HashSet<FileField>());
        }
        this.getSearchFieldSet().add(item);
    }

    public void removeSearchFieldSetItem(FileField item) {
        if (this.getSearchFieldSet() == null) {
            return;
        }
        this.getSearchFieldSet().remove((Object)item);
    }

    public void clearSearchFieldSet() {
        if (this.getSearchFieldSet() != null) {
            this.getSearchFieldSet().clear();
        }
    }

    public List<FileField> getFileFieldList() {
        return this.fileFieldList;
    }

    public void setFileFieldList(List<FileField> fileFieldList) {
        this.fileFieldList = fileFieldList;
    }

    public void addFileFieldListItem(FileField item) {
        if (this.getFileFieldList() == null) {
            this.setFileFieldList(new ArrayList<FileField>());
        }
        this.getFileFieldList().add(item);
        item.setFileTab(this);
    }

    public void removeFileFieldListItem(FileField item) {
        if (this.getFileFieldList() == null) {
            return;
        }
        this.getFileFieldList().remove((Object)item);
    }

    public void clearFileFieldList() {
        if (this.getFileFieldList() != null) {
            this.getFileFieldList().clear();
        }
    }

    public MetaFile getValidationLog() {
        return this.validationLog;
    }

    public void setValidationLog(MetaFile validationLog) {
        this.validationLog = validationLog;
    }

    public AdvancedImport getAdvancedImport() {
        return this.advancedImport;
    }

    public void setAdvancedImport(AdvancedImport advancedImport) {
        this.advancedImport = advancedImport;
    }

    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    public String getSearchCall() {
        return this.searchCall;
    }

    public void setSearchCall(String searchCall) {
        this.searchCall = searchCall;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileTab)) {
            return false;
        }
        FileTab other = (FileTab)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("sequence", (Object)this.getSequence()).add("name", (Object)this.getName()).add("importType", (Object)this.getImportType()).omitNullValues().toString();
    }
}

