/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Department;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_GEOGRAPHICAL_AREA", indexes={@Index(columnList="name")})
public class GeographicalArea
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_GEOGRAPHICAL_AREA_SEQ")
    @SequenceGenerator(name="BASE_GEOGRAPHICAL_AREA_SEQ", sequenceName="BASE_GEOGRAPHICAL_AREA_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Area name")
    private String name;
    @Widget(title="Department")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Department> departmentSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public GeographicalArea() {
    }

    public GeographicalArea(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Department> getDepartmentSet() {
        return this.departmentSet;
    }

    public void setDepartmentSet(Set<Department> departmentSet) {
        this.departmentSet = departmentSet;
    }

    public void addDepartmentSetItem(Department item) {
        if (this.getDepartmentSet() == null) {
            this.setDepartmentSet(new HashSet<Department>());
        }
        this.getDepartmentSet().add(item);
    }

    public void removeDepartmentSetItem(Department item) {
        if (this.getDepartmentSet() == null) {
            return;
        }
        this.getDepartmentSet().remove((Object)item);
    }

    public void clearDepartmentSet() {
        if (this.getDepartmentSet() != null) {
            this.getDepartmentSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeographicalArea)) {
            return false;
        }
        GeographicalArea other = (GeographicalArea)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

