/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.AppBase;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaModel;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_GLOBAL_TRACKING_CONFIGURATION_LINE", uniqueConstraints={@UniqueConstraint(columnNames={"meta_model", "meta_field"})}, indexes={@Index(columnList="meta_model"), @Index(columnList="meta_field"), @Index(columnList="app_base")})
public class GlobalTrackingConfigurationLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_GLOBAL_TRACKING_CONFIGURATION_LINE_SEQ")
    @SequenceGenerator(name="BASE_GLOBAL_TRACKING_CONFIGURATION_LINE_SEQ", sequenceName="BASE_GLOBAL_TRACKING_CONFIGURATION_LINE_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModel metaModel;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaField metaField;
    @NotNull
    private Boolean trackCreation = Boolean.TRUE;
    @NotNull
    private Boolean trackDeletion = Boolean.TRUE;
    @NotNull
    private Boolean trackUpdate = Boolean.TRUE;
    @NotNull
    private Boolean trackExport = Boolean.TRUE;
    @NotNull
    private Boolean trackReading = Boolean.TRUE;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String trackingCondition;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBase appBase;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MetaModel getMetaModel() {
        return this.metaModel;
    }

    public void setMetaModel(MetaModel metaModel) {
        this.metaModel = metaModel;
    }

    public MetaField getMetaField() {
        return this.metaField;
    }

    public void setMetaField(MetaField metaField) {
        this.metaField = metaField;
    }

    public Boolean getTrackCreation() {
        return this.trackCreation == null ? Boolean.FALSE : this.trackCreation;
    }

    public void setTrackCreation(Boolean trackCreation) {
        this.trackCreation = trackCreation;
    }

    public Boolean getTrackDeletion() {
        return this.trackDeletion == null ? Boolean.FALSE : this.trackDeletion;
    }

    public void setTrackDeletion(Boolean trackDeletion) {
        this.trackDeletion = trackDeletion;
    }

    public Boolean getTrackUpdate() {
        return this.trackUpdate == null ? Boolean.FALSE : this.trackUpdate;
    }

    public void setTrackUpdate(Boolean trackUpdate) {
        this.trackUpdate = trackUpdate;
    }

    public Boolean getTrackExport() {
        return this.trackExport == null ? Boolean.FALSE : this.trackExport;
    }

    public void setTrackExport(Boolean trackExport) {
        this.trackExport = trackExport;
    }

    public Boolean getTrackReading() {
        return this.trackReading == null ? Boolean.FALSE : this.trackReading;
    }

    public void setTrackReading(Boolean trackReading) {
        this.trackReading = trackReading;
    }

    public String getTrackingCondition() {
        return this.trackingCondition;
    }

    public void setTrackingCondition(String trackingCondition) {
        this.trackingCondition = trackingCondition;
    }

    public AppBase getAppBase() {
        return this.appBase;
    }

    public void setAppBase(AppBase appBase) {
        this.appBase = appBase;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GlobalTrackingConfigurationLine)) {
            return false;
        }
        GlobalTrackingConfigurationLine other = (GlobalTrackingConfigurationLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("trackCreation", (Object)this.getTrackCreation()).add("trackDeletion", (Object)this.getTrackDeletion()).add("trackUpdate", (Object)this.getTrackUpdate()).add("trackExport", (Object)this.getTrackExport()).add("trackReading", (Object)this.getTrackReading()).omitNullValues().toString();
    }
}

