/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.GlobalTrackingLogLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaModel;
import com.google.common.base.MoreObjects;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_GLOBAL_TRACKING_LOG", indexes={@Index(columnList="user_id"), @Index(columnList="meta_model"), @Index(columnList="meta_file")})
public class GlobalTrackingLog
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_GLOBAL_TRACKING_LOG_SEQ")
    @SequenceGenerator(name="BASE_GLOBAL_TRACKING_LOG_SEQ", sequenceName="BASE_GLOBAL_TRACKING_LOG_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="User", readonly=true)
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Meta model", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModel metaModel;
    @Widget(title="Related id", readonly=true)
    @Column(nullable=true)
    private Long relatedId;
    @Widget(title="Date time", readonly=true)
    private LocalDateTime dateT;
    @Widget(title="Type", readonly=true, selection="global.tracking.log.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Global tracking log line list", readonly=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="globalTrackingLog", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<GlobalTrackingLogLine> globalTrackingLogLineList;
    @Widget(title="Meta file", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile metaFile;
    @Transient
    private String metaModelName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public MetaModel getMetaModel() {
        return this.metaModel;
    }

    public void setMetaModel(MetaModel metaModel) {
        this.metaModel = metaModel;
    }

    public Long getRelatedId() {
        return this.relatedId;
    }

    public void setRelatedId(Long relatedId) {
        this.relatedId = relatedId;
    }

    public LocalDateTime getDateT() {
        return this.dateT;
    }

    public void setDateT(LocalDateTime dateT) {
        this.dateT = dateT;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public List<GlobalTrackingLogLine> getGlobalTrackingLogLineList() {
        return this.globalTrackingLogLineList;
    }

    public void setGlobalTrackingLogLineList(List<GlobalTrackingLogLine> globalTrackingLogLineList) {
        this.globalTrackingLogLineList = globalTrackingLogLineList;
    }

    public void addGlobalTrackingLogLineListItem(GlobalTrackingLogLine item) {
        if (this.getGlobalTrackingLogLineList() == null) {
            this.setGlobalTrackingLogLineList(new ArrayList<GlobalTrackingLogLine>());
        }
        this.getGlobalTrackingLogLineList().add(item);
        item.setGlobalTrackingLog(this);
    }

    public void removeGlobalTrackingLogLineListItem(GlobalTrackingLogLine item) {
        if (this.getGlobalTrackingLogLineList() == null) {
            return;
        }
        this.getGlobalTrackingLogLineList().remove((Object)item);
    }

    public void clearGlobalTrackingLogLineList() {
        if (this.getGlobalTrackingLogLineList() != null) {
            this.getGlobalTrackingLogLineList().clear();
        }
    }

    public MetaFile getMetaFile() {
        return this.metaFile;
    }

    public void setMetaFile(MetaFile metaFile) {
        this.metaFile = metaFile;
    }

    public String getMetaModelName() {
        return this.metaModelName;
    }

    public void setMetaModelName(String metaModelName) {
        this.metaModelName = metaModelName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GlobalTrackingLog)) {
            return false;
        }
        GlobalTrackingLog other = (GlobalTrackingLog)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("relatedId", (Object)this.getRelatedId()).add("dateT", (Object)this.getDateT()).add("typeSelect", (Object)this.getTypeSelect()).add("metaModelName", (Object)this.getMetaModelName()).omitNullValues().toString();
    }
}

