/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.IndicatorGenerator;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_INDICATOR_GENERATOR_GROUPING", indexes={@Index(columnList="name")})
public class IndicatorGeneratorGrouping
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_INDICATOR_GENERATOR_GROUPING_SEQ")
    @SequenceGenerator(name="BASE_INDICATOR_GENERATOR_GROUPING_SEQ", sequenceName="BASE_INDICATOR_GENERATOR_GROUPING_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Code")
    @NameColumn
    @Column(unique=true)
    private String code;
    @Widget(title="Description")
    private String name;
    @Widget(title="Indicator generator list")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<IndicatorGenerator> indicatorGeneratorSet;
    @Widget(title="Result", readonly=true, multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String result;
    @Widget(title="Log", readonly=true, multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String log;
    @Widget(title="Path to export folder")
    private String path;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public IndicatorGeneratorGrouping() {
    }

    public IndicatorGeneratorGrouping(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<IndicatorGenerator> getIndicatorGeneratorSet() {
        return this.indicatorGeneratorSet;
    }

    public void setIndicatorGeneratorSet(Set<IndicatorGenerator> indicatorGeneratorSet) {
        this.indicatorGeneratorSet = indicatorGeneratorSet;
    }

    public void addIndicatorGeneratorSetItem(IndicatorGenerator item) {
        if (this.getIndicatorGeneratorSet() == null) {
            this.setIndicatorGeneratorSet(new HashSet<IndicatorGenerator>());
        }
        this.getIndicatorGeneratorSet().add(item);
    }

    public void removeIndicatorGeneratorSetItem(IndicatorGenerator item) {
        if (this.getIndicatorGeneratorSet() == null) {
            return;
        }
        this.getIndicatorGeneratorSet().remove((Object)item);
    }

    public void clearIndicatorGeneratorSet() {
        if (this.getIndicatorGeneratorSet() != null) {
            this.getIndicatorGeneratorSet().clear();
        }
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndicatorGeneratorGrouping)) {
            return false;
        }
        IndicatorGeneratorGrouping other = (IndicatorGeneratorGrouping)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(1822111431, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).add("path", (Object)this.getPath()).omitNullValues().toString();
    }
}

