/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_PARTNER_ADDRESS", indexes={@Index(columnList="address"), @Index(columnList="partner")})
public class PartnerAddress
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PARTNER_ADDRESS_SEQ")
    @SequenceGenerator(name="BASE_PARTNER_ADDRESS_SEQ", sequenceName="BASE_PARTNER_ADDRESS_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Invoicing address")
    private Boolean isInvoicingAddr = Boolean.FALSE;
    @Widget(title="Delivery address")
    private Boolean isDeliveryAddr = Boolean.FALSE;
    @Widget(title="Default address")
    private Boolean isDefaultAddr = Boolean.FALSE;
    @Widget(title="Address")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address address;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getIsInvoicingAddr() {
        return this.isInvoicingAddr == null ? Boolean.FALSE : this.isInvoicingAddr;
    }

    public void setIsInvoicingAddr(Boolean isInvoicingAddr) {
        this.isInvoicingAddr = isInvoicingAddr;
    }

    public Boolean getIsDeliveryAddr() {
        return this.isDeliveryAddr == null ? Boolean.FALSE : this.isDeliveryAddr;
    }

    public void setIsDeliveryAddr(Boolean isDeliveryAddr) {
        this.isDeliveryAddr = isDeliveryAddr;
    }

    public Boolean getIsDefaultAddr() {
        return this.isDefaultAddr == null ? Boolean.FALSE : this.isDefaultAddr;
    }

    public void setIsDefaultAddr(Boolean isDefaultAddr) {
        this.isDefaultAddr = isDefaultAddr;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PartnerAddress)) {
            return false;
        }
        PartnerAddress other = (PartnerAddress)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("isInvoicingAddr", (Object)this.getIsInvoicingAddr()).add("isDeliveryAddr", (Object)this.getIsDeliveryAddr()).add("isDefaultAddr", (Object)this.getIsDefaultAddr()).omitNullValues().toString();
    }
}

