/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.AdjustHistory;
import com.axelor.apps.base.db.Year;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_PERIOD", indexes={@Index(columnList="name"), @Index(columnList="code"), @Index(columnList="year")})
public class Period
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PERIOD_SEQ")
    @SequenceGenerator(name="BASE_PERIOD_SEQ", sequenceName="BASE_PERIOD_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Code")
    private String code;
    @Widget(title="Year")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Year year;
    @Widget(title="From")
    private LocalDate fromDate;
    @Widget(title="To")
    private LocalDate toDate;
    @Widget(title="Status", readonly=true, selection="base.period.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Closure date")
    private LocalDateTime closureDateTime;
    @Widget(title="Adjust History")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="period", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AdjustHistory> adjustHistoryList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Period() {
    }

    public Period(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Year getYear() {
        return this.year;
    }

    public void setYear(Year year) {
        this.year = year;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public LocalDateTime getClosureDateTime() {
        return this.closureDateTime;
    }

    public void setClosureDateTime(LocalDateTime closureDateTime) {
        this.closureDateTime = closureDateTime;
    }

    public List<AdjustHistory> getAdjustHistoryList() {
        return this.adjustHistoryList;
    }

    public void setAdjustHistoryList(List<AdjustHistory> adjustHistoryList) {
        this.adjustHistoryList = adjustHistoryList;
    }

    public void addAdjustHistoryListItem(AdjustHistory item) {
        if (this.getAdjustHistoryList() == null) {
            this.setAdjustHistoryList(new ArrayList<AdjustHistory>());
        }
        this.getAdjustHistoryList().add(item);
        item.setPeriod(this);
    }

    public void removeAdjustHistoryListItem(AdjustHistory item) {
        if (this.getAdjustHistoryList() == null) {
            return;
        }
        this.getAdjustHistoryList().remove((Object)item);
    }

    public void clearAdjustHistoryList() {
        if (this.getAdjustHistoryList() != null) {
            this.getAdjustHistoryList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Period)) {
            return false;
        }
        Period other = (Period)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("statusSelect", (Object)this.getStatusSelect()).add("closureDateTime", (Object)this.getClosureDateTime()).omitNullValues().toString();
    }
}

