/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Address;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="BASE_PICK_LIST_ENTRY", indexes={@Index(columnList="address"), @Index(columnList="fullName")})
public class PickListEntry
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PICK_LIST_ENTRY_SEQ")
    @SequenceGenerator(name="BASE_PICK_LIST_ENTRY_SEQ", sequenceName="BASE_PICK_LIST_ENTRY_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Picklist QAS")
    private String picklist;
    @Widget(title="Complement")
    private String l2;
    @Widget(title="Spatial information")
    private String l3;
    @Widget(title="Partial address")
    private String partialAddress;
    @Widget(title="Specific information")
    private String l5;
    @Widget(title="Zip")
    private String postcode;
    @Widget(title="INSEE Code")
    private String inseeCode;
    @Widget(title="QAS score")
    private String score;
    @Widget(title="QAS Moniker")
    private String moniker;
    @Widget(title="Address")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address address;
    @Widget(title="Address", search={"score", "picklist"})
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public PickListEntry() {
    }

    public PickListEntry(String postcode) {
        this.postcode = postcode;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPicklist() {
        return this.picklist;
    }

    public void setPicklist(String picklist) {
        this.picklist = picklist;
    }

    public String getL2() {
        return this.l2;
    }

    public void setL2(String l2) {
        this.l2 = l2;
    }

    public String getL3() {
        return this.l3;
    }

    public void setL3(String l3) {
        this.l3 = l3;
    }

    public String getPartialAddress() {
        return this.partialAddress;
    }

    public void setPartialAddress(String partialAddress) {
        this.partialAddress = partialAddress;
    }

    public String getL5() {
        return this.l5;
    }

    public void setL5(String l5) {
        this.l5 = l5;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getInseeCode() {
        return this.inseeCode;
    }

    public void setInseeCode(String inseeCode) {
        this.inseeCode = inseeCode;
    }

    public String getScore() {
        return this.score;
    }

    public void setScore(String score) {
        this.score = score;
    }

    public String getMoniker() {
        return this.moniker;
    }

    public void setMoniker(String moniker) {
        this.moniker = moniker;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullName = "";
        if (this.score != null) {
            fullName = fullName + this.score;
        }
        if (this.picklist != null) {
            fullName = fullName + (fullName.isEmpty() ? "" : " ") + this.picklist;
        }
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PickListEntry)) {
            return false;
        }
        PickListEntry other = (PickListEntry)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("picklist", (Object)this.getPicklist()).add("l2", (Object)this.getL2()).add("l3", (Object)this.getL3()).add("partialAddress", (Object)this.getPartialAddress()).add("l5", (Object)this.getL5()).add("postcode", (Object)this.getPostcode()).add("inseeCode", (Object)this.getInseeCode()).add("score", (Object)this.getScore()).add("moniker", (Object)this.getMoniker()).omitNullValues().toString();
    }
}

