/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.PriceListLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_PRICE_LIST", indexes={@Index(columnList="title"), @Index(columnList="parent_price_list")})
public class PriceList
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PRICE_LIST_SEQ")
    @SequenceGenerator(name="BASE_PRICE_LIST_SEQ", sequenceName="BASE_PRICE_LIST_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Title")
    @NameColumn
    @NotNull
    private String title;
    @Widget(title="Active")
    private Boolean isActive = Boolean.FALSE;
    @Widget(title="Comments")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    @Widget(title="Price list content")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="priceList", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PriceListLine> priceListLineList;
    @Widget(title="Hide Discount on prints")
    private Boolean hideDiscount = Boolean.FALSE;
    @Widget(title="General discount (%)")
    @DecimalMin(value="0")
    @DecimalMax(value="100")
    private BigDecimal generalDiscount = BigDecimal.ZERO;
    @Widget(title="Type", selection="base.price.list.type.select")
    @NotNull
    private Integer typeSelect = 0;
    @Widget(title="Based on")
    private Integer basedOnSelect = 0;
    @Widget(title="Historized Price Lists")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentPriceList", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PriceList> historizedPriceList;
    @Widget(title="Parent Price List")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PriceList parentPriceList;
    @Widget(title="Application begin date")
    private LocalDate applicationBeginDate;
    @Widget(title="Application end date")
    private LocalDate applicationEndDate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Boolean getIsActive() {
        return this.isActive == null ? Boolean.FALSE : this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public List<PriceListLine> getPriceListLineList() {
        return this.priceListLineList;
    }

    public void setPriceListLineList(List<PriceListLine> priceListLineList) {
        this.priceListLineList = priceListLineList;
    }

    public void addPriceListLineListItem(PriceListLine item) {
        if (this.getPriceListLineList() == null) {
            this.setPriceListLineList(new ArrayList<PriceListLine>());
        }
        this.getPriceListLineList().add(item);
        item.setPriceList(this);
    }

    public void removePriceListLineListItem(PriceListLine item) {
        if (this.getPriceListLineList() == null) {
            return;
        }
        this.getPriceListLineList().remove((Object)item);
    }

    public void clearPriceListLineList() {
        if (this.getPriceListLineList() != null) {
            this.getPriceListLineList().clear();
        }
    }

    public Boolean getHideDiscount() {
        return this.hideDiscount == null ? Boolean.FALSE : this.hideDiscount;
    }

    public void setHideDiscount(Boolean hideDiscount) {
        this.hideDiscount = hideDiscount;
    }

    public BigDecimal getGeneralDiscount() {
        return this.generalDiscount == null ? BigDecimal.ZERO : this.generalDiscount;
    }

    public void setGeneralDiscount(BigDecimal generalDiscount) {
        this.generalDiscount = generalDiscount;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Integer getBasedOnSelect() {
        return this.basedOnSelect == null ? 0 : this.basedOnSelect;
    }

    public void setBasedOnSelect(Integer basedOnSelect) {
        this.basedOnSelect = basedOnSelect;
    }

    public List<PriceList> getHistorizedPriceList() {
        return this.historizedPriceList;
    }

    public void setHistorizedPriceList(List<PriceList> historizedPriceList) {
        this.historizedPriceList = historizedPriceList;
    }

    public void addHistorizedPriceListItem(PriceList item) {
        if (this.getHistorizedPriceList() == null) {
            this.setHistorizedPriceList(new ArrayList<PriceList>());
        }
        this.getHistorizedPriceList().add(item);
        item.setParentPriceList(this);
    }

    public void removeHistorizedPriceListItem(PriceList item) {
        if (this.getHistorizedPriceList() == null) {
            return;
        }
        this.getHistorizedPriceList().remove((Object)item);
    }

    public void clearHistorizedPriceList() {
        if (this.getHistorizedPriceList() != null) {
            this.getHistorizedPriceList().clear();
        }
    }

    public PriceList getParentPriceList() {
        return this.parentPriceList;
    }

    public void setParentPriceList(PriceList parentPriceList) {
        this.parentPriceList = parentPriceList;
    }

    public LocalDate getApplicationBeginDate() {
        return this.applicationBeginDate;
    }

    public void setApplicationBeginDate(LocalDate applicationBeginDate) {
        this.applicationBeginDate = applicationBeginDate;
    }

    public LocalDate getApplicationEndDate() {
        return this.applicationEndDate;
    }

    public void setApplicationEndDate(LocalDate applicationEndDate) {
        this.applicationEndDate = applicationEndDate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PriceList)) {
            return false;
        }
        PriceList other = (PriceList)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("title", (Object)this.getTitle()).add("isActive", (Object)this.getIsActive()).add("hideDiscount", (Object)this.getHideDiscount()).add("generalDiscount", (Object)this.getGeneralDiscount()).add("typeSelect", (Object)this.getTypeSelect()).add("basedOnSelect", (Object)this.getBasedOnSelect()).add("applicationBeginDate", (Object)this.getApplicationBeginDate()).add("applicationEndDate", (Object)this.getApplicationEndDate()).omitNullValues().toString();
    }
}

