/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ProductCategory;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_PRICE_LIST_LINE", indexes={@Index(columnList="price_list"), @Index(columnList="product"), @Index(columnList="product_category")})
public class PriceListLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PRICE_LIST_LINE_SEQ")
    @SequenceGenerator(name="BASE_PRICE_LIST_LINE_SEQ", sequenceName="BASE_PRICE_LIST_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Price list")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PriceList priceList;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Product category")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductCategory productCategory;
    @Widget(title="Discount/Additionnal/Replace", selection="base.price.list.line.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Fixed Amount/%", selection="base.price.list.line.amount.type.select")
    private Integer amountTypeSelect = 0;
    @Widget(title="Amount/%")
    @DecimalMin(value="0")
    @Digits(integer=10, fraction=10)
    private BigDecimal amount = BigDecimal.ZERO;
    @Widget(title="Qty min (by product)")
    @DecimalMin(value="0")
    @Digits(integer=10, fraction=10)
    private BigDecimal minQty = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PriceList getPriceList() {
        return this.priceList;
    }

    public void setPriceList(PriceList priceList) {
        this.priceList = priceList;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public ProductCategory getProductCategory() {
        return this.productCategory;
    }

    public void setProductCategory(ProductCategory productCategory) {
        this.productCategory = productCategory;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Integer getAmountTypeSelect() {
        return this.amountTypeSelect == null ? 0 : this.amountTypeSelect;
    }

    public void setAmountTypeSelect(Integer amountTypeSelect) {
        this.amountTypeSelect = amountTypeSelect;
    }

    public BigDecimal getAmount() {
        return this.amount == null ? BigDecimal.ZERO : this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getMinQty() {
        return this.minQty == null ? BigDecimal.ZERO : this.minQty;
    }

    public void setMinQty(BigDecimal minQty) {
        this.minQty = minQty;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PriceListLine)) {
            return false;
        }
        PriceListLine other = (PriceListLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("typeSelect", (Object)this.getTypeSelect()).add("amountTypeSelect", (Object)this.getAmountTypeSelect()).add("amount", (Object)this.getAmount()).add("minQty", (Object)this.getMinQty()).omitNullValues().toString();
    }
}

