/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.BirtTemplate;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_PRINTING_SETTINGS", indexes={@Index(columnList="name"), @Index(columnList="default_mail_birt_template"), @Index(columnList="company")})
public class PrintingSettings
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PRINTING_SETTINGS_SEQ")
    @SequenceGenerator(name="BASE_PRINTING_SETTINGS_SEQ", sequenceName="BASE_PRINTING_SETTINGS_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    private String name;
    @Widget(title="Company Header")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String pdfHeader;
    @Widget(title="Company Footer")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String pdfFooter;
    @Widget(title="Birt Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BirtTemplate defaultMailBirtTemplate;
    @Widget(title="Logo position", selection="printing.setting.logo.position")
    private Integer logoPositionSelect = 0;
    @Widget(title="Color code (hex)")
    private String colorCode;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Company Header Height(in cm)")
    private BigDecimal pdfHeaderHeight = BigDecimal.ZERO;
    @Widget(title="Company Footer Height(in cm)")
    private BigDecimal pdfFooterHeight = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public PrintingSettings() {
    }

    public PrintingSettings(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPdfHeader() {
        return this.pdfHeader;
    }

    public void setPdfHeader(String pdfHeader) {
        this.pdfHeader = pdfHeader;
    }

    public String getPdfFooter() {
        return this.pdfFooter;
    }

    public void setPdfFooter(String pdfFooter) {
        this.pdfFooter = pdfFooter;
    }

    public BirtTemplate getDefaultMailBirtTemplate() {
        return this.defaultMailBirtTemplate;
    }

    public void setDefaultMailBirtTemplate(BirtTemplate defaultMailBirtTemplate) {
        this.defaultMailBirtTemplate = defaultMailBirtTemplate;
    }

    public Integer getLogoPositionSelect() {
        return this.logoPositionSelect == null ? 0 : this.logoPositionSelect;
    }

    public void setLogoPositionSelect(Integer logoPositionSelect) {
        this.logoPositionSelect = logoPositionSelect;
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public void setColorCode(String colorCode) {
        this.colorCode = colorCode;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public BigDecimal getPdfHeaderHeight() {
        return this.pdfHeaderHeight == null ? BigDecimal.ZERO : this.pdfHeaderHeight;
    }

    public void setPdfHeaderHeight(BigDecimal pdfHeaderHeight) {
        this.pdfHeaderHeight = pdfHeaderHeight;
    }

    public BigDecimal getPdfFooterHeight() {
        return this.pdfFooterHeight == null ? BigDecimal.ZERO : this.pdfFooterHeight;
    }

    public void setPdfFooterHeight(BigDecimal pdfFooterHeight) {
        this.pdfFooterHeight = pdfFooterHeight;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PrintingSettings)) {
            return false;
        }
        PrintingSettings other = (PrintingSettings)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("logoPositionSelect", (Object)this.getLogoPositionSelect()).add("colorCode", (Object)this.getColorCode()).add("pdfHeaderHeight", (Object)this.getPdfHeaderHeight()).add("pdfFooterHeight", (Object)this.getPdfFooterHeight()).omitNullValues().toString();
    }
}

