/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.ProductVariantAttr;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_PRODUCT_VARIANT_VALUE", indexes={@Index(columnList="name"), @Index(columnList="code"), @Index(columnList="product_variant_attr")})
public class ProductVariantValue
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PRODUCT_VARIANT_VALUE_SEQ")
    @SequenceGenerator(name="BASE_PRODUCT_VARIANT_VALUE_SEQ", sequenceName="BASE_PRODUCT_VARIANT_VALUE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Code")
    @NotNull
    private String code;
    @Widget(title="Display color", selection="color.name.selection")
    private String colorSelect;
    @Widget(title="Price Extra")
    @Digits(integer=10, fraction=10)
    private BigDecimal priceExtra = BigDecimal.ZERO;
    @Widget(title="Application", selection="ibase.product.variant.value.application.price.select")
    private Integer applicationPriceSelect = 0;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantAttr productVariantAttr;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ProductVariantValue() {
    }

    public ProductVariantValue(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getColorSelect() {
        return this.colorSelect;
    }

    public void setColorSelect(String colorSelect) {
        this.colorSelect = colorSelect;
    }

    public BigDecimal getPriceExtra() {
        return this.priceExtra == null ? BigDecimal.ZERO : this.priceExtra;
    }

    public void setPriceExtra(BigDecimal priceExtra) {
        this.priceExtra = priceExtra;
    }

    public Integer getApplicationPriceSelect() {
        return this.applicationPriceSelect == null ? 0 : this.applicationPriceSelect;
    }

    public void setApplicationPriceSelect(Integer applicationPriceSelect) {
        this.applicationPriceSelect = applicationPriceSelect;
    }

    public ProductVariantAttr getProductVariantAttr() {
        return this.productVariantAttr;
    }

    public void setProductVariantAttr(ProductVariantAttr productVariantAttr) {
        this.productVariantAttr = productVariantAttr;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProductVariantValue)) {
            return false;
        }
        ProductVariantValue other = (ProductVariantValue)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("colorSelect", (Object)this.getColorSelect()).add("priceExtra", (Object)this.getPriceExtra()).add("applicationPriceSelect", (Object)this.getApplicationPriceSelect()).omitNullValues().toString();
    }
}

