/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.SyncContactHistoric;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_SYNC_CONTACT", indexes={@Index(columnList="name")})
public class SyncContact
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_SYNC_CONTACT_SEQ")
    @SequenceGenerator(name="BASE_SYNC_CONTACT_SEQ", sequenceName="BASE_SYNC_CONTACT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Client ID")
    @NotNull
    private String cid;
    @Widget(title="Google api key")
    @NotNull
    private String googleApiKey;
    @Widget(title="Update contact field")
    private Boolean updateContactField = Boolean.FALSE;
    @Widget(title="Historic")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="syncContact", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SyncContactHistoric> syncContactHistoricList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public SyncContact() {
    }

    public SyncContact(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCid() {
        return this.cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public String getGoogleApiKey() {
        return this.googleApiKey;
    }

    public void setGoogleApiKey(String googleApiKey) {
        this.googleApiKey = googleApiKey;
    }

    public Boolean getUpdateContactField() {
        return this.updateContactField == null ? Boolean.FALSE : this.updateContactField;
    }

    public void setUpdateContactField(Boolean updateContactField) {
        this.updateContactField = updateContactField;
    }

    public List<SyncContactHistoric> getSyncContactHistoricList() {
        return this.syncContactHistoricList;
    }

    public void setSyncContactHistoricList(List<SyncContactHistoric> syncContactHistoricList) {
        this.syncContactHistoricList = syncContactHistoricList;
    }

    public void addSyncContactHistoricListItem(SyncContactHistoric item) {
        if (this.getSyncContactHistoricList() == null) {
            this.setSyncContactHistoricList(new ArrayList<SyncContactHistoric>());
        }
        this.getSyncContactHistoricList().add(item);
        item.setSyncContact(this);
    }

    public void removeSyncContactHistoricListItem(SyncContactHistoric item) {
        if (this.getSyncContactHistoricList() == null) {
            return;
        }
        this.getSyncContactHistoricList().remove((Object)item);
    }

    public void clearSyncContactHistoricList() {
        if (this.getSyncContactHistoricList() != null) {
            this.getSyncContactHistoricList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SyncContact)) {
            return false;
        }
        SyncContact other = (SyncContact)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("cid", (Object)this.getCid()).add("googleApiKey", (Object)this.getGoogleApiKey()).add("updateContactField", (Object)this.getUpdateContactField()).omitNullValues().toString();
    }
}

