/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.SyncContact;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_SYNC_CONTACT_HISTORIC", indexes={@Index(columnList="user_id"), @Index(columnList="sync_contact")})
public class SyncContactHistoric
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_SYNC_CONTACT_HISTORIC_SEQ")
    @SequenceGenerator(name="BASE_SYNC_CONTACT_HISTORIC_SEQ", sequenceName="BASE_SYNC_CONTACT_HISTORIC_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="User")
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Imported contact")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Partner> partnerSet;
    @Widget(title="SyncContact")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SyncContact syncContact;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Set<Partner> getPartnerSet() {
        return this.partnerSet;
    }

    public void setPartnerSet(Set<Partner> partnerSet) {
        this.partnerSet = partnerSet;
    }

    public void addPartnerSetItem(Partner item) {
        if (this.getPartnerSet() == null) {
            this.setPartnerSet(new HashSet<Partner>());
        }
        this.getPartnerSet().add(item);
    }

    public void removePartnerSetItem(Partner item) {
        if (this.getPartnerSet() == null) {
            return;
        }
        this.getPartnerSet().remove((Object)item);
    }

    public void clearPartnerSet() {
        if (this.getPartnerSet() != null) {
            this.getPartnerSet().clear();
        }
    }

    public SyncContact getSyncContact() {
        return this.syncContact;
    }

    public void setSyncContact(SyncContact syncContact) {
        this.syncContact = syncContact;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SyncContactHistoric)) {
            return false;
        }
        SyncContactHistoric other = (SyncContactHistoric)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).omitNullValues().toString();
    }
}

