/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db.repo;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.BarcodeGeneratorService;
import com.axelor.apps.base.service.ProductService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.tool.service.TranslationService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import javax.persistence.PersistenceException;
import javax.validation.ValidationException;

public class ProductBaseRepository
extends ProductRepository {
    @Inject
    private MetaFiles metaFiles;
    @Inject
    protected AppBaseService appBaseService;
    @Inject
    protected TranslationService translationService;
    protected static final String FULL_NAME_FORMAT = "[%s] %s";
    @Inject
    protected BarcodeGeneratorService barcodeGeneratorService;

    public Product save(Product product) {
        try {
            if (this.appBaseService.getAppBase().getGenerateProductSequence().booleanValue() && Strings.isNullOrEmpty((String)product.getCode())) {
                product.setCode(((ProductService)Beans.get(ProductService.class)).getSequence());
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
        product.setFullName(String.format(FULL_NAME_FORMAT, product.getCode(), product.getName()));
        if (product.getId() != null) {
            Product oldProduct = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find(product.getId()));
            this.translationService.updateFormatedValueTranslations(oldProduct.getFullName(), FULL_NAME_FORMAT, new Object[]{product.getCode(), product.getName()});
        } else {
            this.translationService.createFormatedValueTranslations(FULL_NAME_FORMAT, new Object[]{product.getCode(), product.getName()});
        }
        product = (Product)((Object)super.save((Model)((Object)product)));
        if (product.getBarCode() == null && this.appBaseService.getAppBase().getActivateBarCodeGeneration().booleanValue()) {
            try {
                boolean addPadding = false;
                InputStream inStream = this.appBaseService.getAppBase().getEditProductBarcodeType() == false ? this.barcodeGeneratorService.createBarCode(product.getSerialNumber(), this.appBaseService.getAppBase().getBarcodeTypeConfig(), addPadding) : this.barcodeGeneratorService.createBarCode(product.getSerialNumber(), product.getBarcodeTypeConfig(), addPadding);
                if (inStream != null) {
                    MetaFile barcodeFile = this.metaFiles.upload(inStream, String.format("ProductBarCode%d.png", product.getId()));
                    product.setBarCode(barcodeFile);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (AxelorException e) {
                throw new ValidationException(e.getMessage());
            }
        }
        return (Product)((Object)super.save((Model)((Object)product)));
    }

    public Product copy(Product product, boolean deep) {
        Product copy = (Product)((Object)super.copy((Model)((Object)product), deep));
        ((ProductService)Beans.get(ProductService.class)).copyProduct(product, copy);
        try {
            if (this.appBaseService.getAppBase().getGenerateProductSequence().booleanValue()) {
                copy.setCode(((ProductService)Beans.get(ProductService.class)).getSequence());
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
        return copy;
    }
}

