/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db.repo;

import com.axelor.apps.base.db.Frequency;
import com.axelor.apps.base.service.TeamTaskService;
import com.axelor.db.Model;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import javax.persistence.PersistenceException;

public class TeamTaskBaseRepository
extends TeamTaskRepository {
    public TeamTask save(TeamTask teamTask) {
        Frequency frequency;
        TeamTaskService teamTaskService = (TeamTaskService)Beans.get(TeamTaskService.class);
        if (teamTask.getDoApplyToAllNextTasks().booleanValue() && teamTask.getNextTeamTask() != null && teamTask.getHasDateOrFrequencyChanged().booleanValue()) {
            teamTaskService.removeNextTasks(teamTask);
            teamTask.setIsFirst(true);
        }
        if ((frequency = teamTask.getFrequency()) != null && teamTask.getIsFirst().booleanValue() && teamTask.getNextTeamTask() == null) {
            if (teamTask.getTaskDate() != null) {
                if (frequency.getEndDate().isBefore(teamTask.getTaskDate())) {
                    throw new PersistenceException(I18n.get((String)"Frequency end date cannot be before task date."));
                }
            } else {
                throw new PersistenceException(I18n.get((String)"Please fill in task date."));
            }
            teamTaskService.generateTasks(teamTask, frequency);
        }
        if (teamTask.getDoApplyToAllNextTasks().booleanValue()) {
            teamTaskService.updateNextTask(teamTask);
        }
        teamTask.setDoApplyToAllNextTasks(false);
        teamTask.setHasDateOrFrequencyChanged(false);
        return (TeamTask)((Object)super.save((Model)((Object)teamTask)));
    }

    public TeamTask copy(TeamTask entity, boolean deep) {
        TeamTask task = (TeamTask)((Object)super.copy((Model)((Object)entity), deep));
        task.setAssignedTo(null);
        task.setTaskDate(null);
        task.setPriority(null);
        return task;
    }
}

