/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db.repo;

import com.axelor.app.AppSettings;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerBaseRepository;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.inject.Beans;
import javax.persistence.PersistenceException;

public class UserBaseRepository
extends UserRepository {
    public User save(User user) {
        try {
            AppSettings appSettings = AppSettings.get();
            String defaultLanguage = appSettings.get("application.locale");
            if (user.getId() == null && defaultLanguage != null && !"".equals(defaultLanguage) && (user.getLanguage() == null || "".contentEquals(user.getLanguage()))) {
                user.setLanguage(appSettings.get("application.locale"));
            }
            if (user.getPartner() != null && user.getPartner().getEmailAddress() != null && StringUtils.notBlank((CharSequence)user.getPartner().getEmailAddress().getAddress()) && !user.getPartner().getEmailAddress().getAddress().equals(user.getEmail())) {
                user.setEmail(user.getPartner().getEmailAddress().getAddress());
            }
            if (StringUtils.notBlank((CharSequence)(user = (User)((Object)super.save((Model)((Object)user)))).getTransientPassword())) {
                ((UserService)Beans.get(UserService.class)).processChangedPassword(user);
            }
            return user;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }

    public User copy(User entity, boolean deep) {
        User copy = new User();
        copy.setGroup(entity.getGroup());
        copy.setRoles(entity.getRoles());
        copy.setPermissions(entity.getPermissions());
        copy.setMetaPermissions(entity.getMetaPermissions());
        copy.setActiveCompany(entity.getActiveCompany());
        copy.setCompanySet(entity.getCompanySet());
        copy.setLanguage(entity.getLanguage());
        copy.setHomeAction(entity.getHomeAction());
        copy.setSingleTab(entity.getSingleTab());
        copy.setNoHelp(entity.getNoHelp());
        return (User)((Object)super.copy((Model)((Object)copy), deep));
    }

    public void remove(User user) {
        PartnerBaseRepository partnerRepo;
        Partner partner;
        if (user.getPartner() != null && (partner = (Partner)((Object)(partnerRepo = (PartnerBaseRepository)((Object)Beans.get(PartnerBaseRepository.class))).find(user.getPartner().getId()))) != null) {
            partner.setLinkedUser(null);
            partnerRepo.save(partner);
        }
        super.remove((Model)((Object)user));
    }

    @Override
    public User findByEmail(String email) {
        return (User)((Object)Query.of(User.class).filter("LOWER(self.partner.emailAddress.address) = LOWER(:email) OR LOWER(self.email) = LOWER(:email)").bind("email", (Object)email).cacheable().fetchOne());
    }

    @Override
    public User findByCodeOrEmail(String codeOrEmail) {
        return (User)((Object)Query.of(User.class).filter("LOWER(self.code) = LOWER(:codeOrEmail) OR LOWER(self.partner.emailAddress.address) = LOWER(:codeOrEmail) OR LOWER(self.email) = LOWER(:codeOrEmail)").bind("codeOrEmail", (Object)codeOrEmail).cacheable().fetchOne());
    }
}

