/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.job;

import com.axelor.apps.base.job.ThreadedJob;
import com.axelor.apps.base.job.UncheckedJobExecutionException;
import com.axelor.apps.base.service.administration.AbstractBatchService;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaSchedule;
import com.axelor.meta.db.repo.MetaScheduleRepository;
import com.axelor.rpc.Context;
import com.axelor.script.GroovyScriptHelper;
import com.axelor.script.ScriptHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;

public class BatchJob
extends ThreadedJob {
    public void executeInThread(JobExecutionContext context) {
        Class<AbstractBatchService> batchServiceClass;
        JobDetail jobDetail = context.getJobDetail();
        MetaSchedule metaSchedule = ((MetaScheduleRepository)((Object)Beans.get(MetaScheduleRepository.class))).findByName(jobDetail.getKey().getName());
        String batchServiceClassName = metaSchedule.getBatchServiceSelect();
        try {
            batchServiceClass = Class.forName(batchServiceClassName).asSubclass(AbstractBatchService.class);
        }
        catch (ClassNotFoundException e) {
            throw new UncheckedJobExecutionException((Throwable)e);
        }
        AbstractBatchService batchService = (AbstractBatchService)Beans.get(batchServiceClass);
        String batchCode = metaSchedule.getBatchCode();
        Model batchModel = batchService.findModelByCode(batchCode);
        if (batchModel == null) {
            String msg = String.format("Batch %s not found with service %s", batchCode, batchServiceClassName);
            throw new UncheckedJobExecutionException(msg);
        }
        Map<String, Object> originalProperties = this.applyBeanPropertiesWithScriptHelper(batchModel, (Map<String, Object>)jobDetail.getJobDataMap());
        try {
            batchService.run(batchModel);
        }
        catch (Exception e) {
            throw new UncheckedJobExecutionException((Throwable)e);
        }
        finally {
            if (!JPA.em().contains((Object)batchModel)) {
                batchModel = batchService.findModelByCode(batchCode);
            }
            this.applyBeanProperties(batchModel, originalProperties);
        }
    }

    private Map<String, Object> applyBeanPropertiesWithScriptHelper(Object bean, Map<String, Object> properties) {
        Context scriptContext = new Context(Mapper.toMap((Object)bean), bean.getClass());
        GroovyScriptHelper scriptHelper = new GroovyScriptHelper(scriptContext);
        return this.applyBeanProperties(bean, properties, arg_0 -> BatchJob.lambda$applyBeanPropertiesWithScriptHelper$0((ScriptHelper)scriptHelper, arg_0));
    }

    private Map<String, Object> applyBeanProperties(Object bean, Map<String, Object> properties) {
        return this.applyBeanProperties(bean, properties, value -> value);
    }

    private Map<String, Object> applyBeanProperties(Object bean, Map<String, Object> properties, Function<Object, Object> evalFunc) {
        HashMap<String, Object> originalProperties = new HashMap<String, Object>();
        JPA.runInTransaction(() -> {
            for (Map.Entry entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                if (!PropertyUtils.isWriteable((Object)bean, (String)key)) continue;
                try {
                    originalProperties.put(key, BeanUtils.getProperty((Object)bean, (String)key));
                    Object value = evalFunc.apply(entry.getValue());
                    BeanUtils.setProperty((Object)bean, (String)key, value);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new UncheckedJobExecutionException((Throwable)e);
                }
            }
        });
        return originalProperties;
    }

    private static /* synthetic */ Object lambda$applyBeanPropertiesWithScriptHelper$0(ScriptHelper scriptHelper, Object value) {
        return scriptHelper.eval(value.toString());
    }
}

