/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.ABCAnalysis;
import com.axelor.apps.base.db.ABCAnalysisClass;
import com.axelor.apps.base.db.ABCAnalysisLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.base.db.repo.ABCAnalysisClassRepository;
import com.axelor.apps.base.db.repo.ABCAnalysisLineRepository;
import com.axelor.apps.base.db.repo.ABCAnalysisRepository;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.ABCAnalysisService;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ABCAnalysisServiceImpl
implements ABCAnalysisService {
    protected ABCAnalysisLineRepository abcAnalysisLineRepository;
    protected UnitConversionService unitConversionService;
    protected SequenceService sequenceService;
    protected ABCAnalysisRepository abcAnalysisRepository;
    protected ProductRepository productRepository;
    protected ABCAnalysisClassRepository abcAnalysisClassRepository;
    private BigDecimal totalQty = BigDecimal.ZERO;
    private BigDecimal totalWorth = BigDecimal.ZERO;
    private BigDecimal cumulatedQty = BigDecimal.valueOf(0L, 3);
    private BigDecimal cumulatedWorth = BigDecimal.valueOf(0L, 3);
    private final String abcAnalysisSequenceCode = "abcAnalysis";
    private List<ABCAnalysisClass> abcAnalysisClassList;

    @Inject
    public ABCAnalysisServiceImpl(ABCAnalysisLineRepository abcAnalysisLineRepository, UnitConversionService unitConversionService, ABCAnalysisRepository abcAnalysisRepository, ProductRepository productRepository, ABCAnalysisClassRepository abcAnalysisClassRepository, SequenceService sequenceService) {
        this.abcAnalysisLineRepository = abcAnalysisLineRepository;
        this.unitConversionService = unitConversionService;
        this.abcAnalysisRepository = abcAnalysisRepository;
        this.productRepository = productRepository;
        this.abcAnalysisClassRepository = abcAnalysisClassRepository;
        this.sequenceService = sequenceService;
    }

    @Override
    public List<ABCAnalysisClass> initABCClasses() {
        ArrayList<ABCAnalysisClass> abcAnalysisClassList = new ArrayList<ABCAnalysisClass>();
        abcAnalysisClassList.add(this.createAbcClass("A", 0, BigDecimal.valueOf(80L), BigDecimal.valueOf(20L)));
        abcAnalysisClassList.add(this.createAbcClass("B", 1, BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)));
        abcAnalysisClassList.add(this.createAbcClass("C", 2, BigDecimal.valueOf(5L), BigDecimal.valueOf(50L)));
        return abcAnalysisClassList;
    }

    private ABCAnalysisClass createAbcClass(String name, Integer sequence, BigDecimal worth, BigDecimal qty) {
        ABCAnalysisClass abcAnalysisClass = new ABCAnalysisClass();
        abcAnalysisClass.setName(name);
        abcAnalysisClass.setSequence(sequence);
        abcAnalysisClass.setWorth(worth);
        abcAnalysisClass.setQty(qty);
        return abcAnalysisClass;
    }

    @Override
    @Transactional
    public void reset(ABCAnalysis abcAnalysis) {
        this.abcAnalysisLineRepository.all().filter("self.abcAnalysis.id = :abcAnalysisId").bind("abcAnalysisId", (Object)abcAnalysis.getId()).remove();
        abcAnalysis.setStatusSelect(1);
        this.abcAnalysisRepository.save((Model)((Object)abcAnalysis));
    }

    @Override
    public void runAnalysis(ABCAnalysis abcAnalysis) throws AxelorException {
        this.reset(abcAnalysis);
        this.start(abcAnalysis);
        this.getAbcAnalysisClassList(abcAnalysis);
        this.createAllABCAnalysisLine(abcAnalysis);
        this.doAnalysis((ABCAnalysis)((Object)this.abcAnalysisRepository.find(abcAnalysis.getId())));
        this.finish((ABCAnalysis)((Object)this.abcAnalysisRepository.find(abcAnalysis.getId())));
    }

    @Transactional
    protected void start(ABCAnalysis abcAnalysis) {
        abcAnalysis.setStatusSelect(2);
        this.abcAnalysisRepository.save((Model)((Object)abcAnalysis));
    }

    private void getAbcAnalysisClassList(ABCAnalysis abcAnalysis) {
        Query abcAnalysisClassQuery = this.abcAnalysisClassRepository.all().filter("self.abcAnalysis.id = :abcAnalysisId").bind("abcAnalysisId", (Object)abcAnalysis.getId()).order("sequence");
        this.abcAnalysisClassList = abcAnalysisClassQuery.fetch();
    }

    private Set<Product> getProductSet(ABCAnalysis abcAnalysis) {
        HashSet<Product> productList = new HashSet<Product>();
        String productCategoryQuery = this.getProductCategoryQuery();
        String productFamilyQuery = this.getProductFamilyQuery();
        if (!abcAnalysis.getProductSet().isEmpty()) {
            productList.addAll(abcAnalysis.getProductSet());
        }
        if (!abcAnalysis.getProductCategorySet().isEmpty()) {
            productList.addAll(this.productRepository.all().filter(productCategoryQuery, new Object[]{abcAnalysis.getProductCategorySet(), "storable"}).fetch());
        }
        if (!abcAnalysis.getProductFamilySet().isEmpty()) {
            productList.addAll(this.productRepository.all().filter(productFamilyQuery, new Object[]{abcAnalysis.getProductFamilySet(), "storable"}).fetch());
        }
        return productList;
    }

    protected String getProductCategoryQuery() {
        return "self.productCategory in (?1) AND self.productTypeSelect = ?2 AND self.dtype = 'Product'";
    }

    protected String getProductFamilyQuery() {
        return "self.productFamily in (?1) AND self.productTypeSelect = ?2 AND self.dtype = 'Product'";
    }

    protected void createAllABCAnalysisLine(ABCAnalysis abcAnalysis) throws AxelorException {
        List productList;
        int offset = 0;
        Query productQuery = this.productRepository.all().filter("self.id IN (" + StringTool.getIdListString(this.getProductSet(abcAnalysis)) + ")");
        while (!(productList = productQuery.fetch(10, offset)).isEmpty()) {
            abcAnalysis = (ABCAnalysis)((Object)this.abcAnalysisRepository.find(abcAnalysis.getId()));
            offset += productList.size();
            for (Product product : productList) {
                product = (Product)((Object)this.productRepository.find(product.getId()));
                this.createABCAnalysisLineForEachProduct(abcAnalysis, product);
            }
            JPA.clear();
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected void createABCAnalysisLineForEachProduct(ABCAnalysis abcAnalysis, Product product) throws AxelorException {
        Optional<ABCAnalysisLine> optionalAbcAnalysisLine = this.createABCAnalysisLine(abcAnalysis, product);
        optionalAbcAnalysisLine.ifPresent(abcAnalysisLine -> {
            if ((abcAnalysisLine = (ABCAnalysisLine)((Object)((Object)this.abcAnalysisLineRepository.find(abcAnalysisLine.getId())))).getDecimalWorth().compareTo(BigDecimal.ZERO) == 0 && abcAnalysisLine.getDecimalQty().compareTo(BigDecimal.ZERO) == 0) {
                this.abcAnalysisLineRepository.remove(this.abcAnalysisLineRepository.find(abcAnalysisLine.getId()));
            }
        });
    }

    @Transactional(rollbackOn={Exception.class})
    protected Optional<ABCAnalysisLine> createABCAnalysisLine(ABCAnalysis abcAnalysis, Product product) throws AxelorException {
        ABCAnalysisLine abcAnalysisLine = new ABCAnalysisLine();
        abcAnalysisLine.setAbcAnalysis(abcAnalysis);
        abcAnalysisLine.setProduct(product);
        this.abcAnalysisLineRepository.save((Model)((Object)abcAnalysisLine));
        return Optional.of(abcAnalysisLine);
    }

    @Transactional
    protected void setQtyWorth(ABCAnalysisLine abcAnalysisLine, BigDecimal decimalQty, BigDecimal decimalWorth) {
        abcAnalysisLine.setDecimalQty(decimalQty);
        abcAnalysisLine.setDecimalWorth(decimalWorth);
        this.abcAnalysisLineRepository.save((Model)((Object)abcAnalysisLine));
    }

    protected void doAnalysis(ABCAnalysis abcAnalysis) {
        List abcAnalysisLineList;
        int offset = 0;
        Query query = this.abcAnalysisLineRepository.all().filter("self.abcAnalysis.id = :abcAnalysisId").bind("abcAnalysisId", (Object)abcAnalysis.getId()).order("-decimalWorth").order("id");
        while (!(abcAnalysisLineList = query.fetch(10, offset)).isEmpty()) {
            offset += abcAnalysisLineList.size();
            abcAnalysisLineList.forEach(this::analyzeLine);
            JPA.clear();
        }
    }

    @Transactional
    protected void analyzeLine(ABCAnalysisLine abcAnalysisLine) {
        this.computePercentage(abcAnalysisLine);
        this.setABCAnalysisClass(abcAnalysisLine);
        this.abcAnalysisLineRepository.save((Model)((Object)abcAnalysisLine));
    }

    private void computePercentage(ABCAnalysisLine abcAnalysisLine) {
        BigDecimal qty = BigDecimal.ZERO;
        if (this.totalQty.compareTo(BigDecimal.ZERO) > 0) {
            qty = abcAnalysisLine.getDecimalQty().multiply(BigDecimal.valueOf(100L)).divide(this.totalQty, 3, RoundingMode.HALF_EVEN);
        }
        BigDecimal worth = BigDecimal.ZERO;
        if (this.totalWorth.compareTo(BigDecimal.ZERO) > 0) {
            worth = abcAnalysisLine.getDecimalWorth().multiply(BigDecimal.valueOf(100L)).divide(this.totalWorth, 3, RoundingMode.HALF_EVEN);
        }
        this.incCumulatedQty(qty);
        this.incCumulatedWorth(worth);
        abcAnalysisLine.setQty(qty);
        abcAnalysisLine.setCumulatedQty(this.cumulatedQty);
        abcAnalysisLine.setWorth(worth);
        abcAnalysisLine.setCumulatedWorth(this.cumulatedWorth);
    }

    protected void setABCAnalysisClass(ABCAnalysisLine abcAnalysisLine) {
        BigDecimal maxQty = BigDecimal.ZERO;
        BigDecimal maxWorth = BigDecimal.ZERO;
        BigDecimal lineCumulatedQty = abcAnalysisLine.getCumulatedQty().setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal lineCumulatedWorth = abcAnalysisLine.getCumulatedWorth().setScale(2, RoundingMode.HALF_EVEN);
        for (ABCAnalysisClass abcAnalysisClass : this.abcAnalysisClassList) {
            maxQty = maxQty.add(abcAnalysisClass.getQty());
            maxWorth = maxWorth.add(abcAnalysisClass.getWorth());
            if (lineCumulatedQty.compareTo(maxQty) > 0 || lineCumulatedWorth.compareTo(maxWorth) > 0) continue;
            abcAnalysisLine.setAbcAnalysisClass((ABCAnalysisClass)((Object)this.abcAnalysisClassRepository.find(abcAnalysisClass.getId())));
            break;
        }
    }

    protected void incTotalQty(BigDecimal totalQty) {
        this.totalQty = this.totalQty.add(totalQty);
    }

    protected void incTotalWorth(BigDecimal totalWorth) {
        this.totalWorth = this.totalWorth.add(totalWorth);
    }

    private void incCumulatedQty(BigDecimal cumulatedQty) {
        this.cumulatedQty = this.cumulatedQty.add(cumulatedQty);
    }

    private void incCumulatedWorth(BigDecimal cumulatedWorth) {
        this.cumulatedWorth = this.cumulatedWorth.add(cumulatedWorth);
    }

    @Transactional
    protected void finish(ABCAnalysis abcAnalysis) {
        abcAnalysis.setStatusSelect(3);
        this.abcAnalysisRepository.save((Model)((Object)abcAnalysis));
    }

    @Override
    public void setSequence(ABCAnalysis abcAnalysis) {
        String abcAnalysisSequence = abcAnalysis.getAbcAnalysisSeq();
        if (abcAnalysisSequence != null && !abcAnalysisSequence.isEmpty()) {
            return;
        }
        Sequence sequence = this.sequenceService.getSequence("abcAnalysis", abcAnalysis.getCompany());
        if (sequence == null) {
            return;
        }
        abcAnalysis.setAbcAnalysisSeq(this.sequenceService.getSequenceNumber(sequence));
    }

    @Override
    public String printReport(ABCAnalysis abcAnalysis, String reportType) throws AxelorException {
        if (abcAnalysis.getStatusSelect() != 3) {
            throw new AxelorException((Model)((Object)abcAnalysis), 5, I18n.get((String)"The analysis must be completed before the report can be printed."));
        }
        String name = I18n.get((String)"ABC Analysis") + " - " + abcAnalysis.getAbcAnalysisSeq();
        return ReportFactory.createReport("AbcAnalysis.rptdesign", name).addParam("abcAnalysisId", abcAnalysis.getId()).addParam("Locale", ReportSettings.getPrintingLocale(null)).addParam("Timezone", abcAnalysis.getCompany() != null ? abcAnalysis.getCompany().getTimezone() : null).addFormat(reportType).toAttach((Model)((Object)abcAnalysis)).generate().getFileLink();
    }

    @Override
    public void checkClasses(ABCAnalysis abcAnalysis) throws AxelorException {
        List<ABCAnalysisClass> abcAnalysisClassList = abcAnalysis.getAbcAnalysisClassList();
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal totalWorth = BigDecimal.ZERO;
        BigDecimal comparisonValue = new BigDecimal(100);
        for (ABCAnalysisClass abcAnalysisClass : abcAnalysisClassList) {
            BigDecimal classQty = abcAnalysisClass.getQty();
            BigDecimal classWorth = abcAnalysisClass.getWorth();
            if (classQty.compareTo(BigDecimal.ZERO) <= 0 || classWorth.compareTo(BigDecimal.ZERO) <= 0) {
                throw new AxelorException((Model)((Object)abcAnalysis), 4, I18n.get((String)"The worth and quantity value of each class must be greater than 0."));
            }
            totalQty = totalQty.add(classQty);
            totalWorth = totalWorth.add(classWorth);
        }
        if (totalQty.compareTo(comparisonValue) != 0 || totalWorth.compareTo(comparisonValue) != 0) {
            throw new AxelorException((Model)((Object)abcAnalysis), 4, I18n.get((String)"The classes total quantity and total worth must equal 100%."));
        }
    }
}

