/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.City;
import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PartnerAddress;
import com.axelor.apps.base.db.PickListEntry;
import com.axelor.apps.base.db.Street;
import com.axelor.apps.base.db.repo.AddressRepository;
import com.axelor.apps.base.db.repo.CityRepository;
import com.axelor.apps.base.db.repo.StreetRepository;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.base.service.MapService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.tool.address.AddressTool;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import com.opencsv.CSVWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wslite.json.JSONException;

@Singleton
public class AddressServiceImpl
implements AddressService {
    @Inject
    protected AddressRepository addressRepo;
    @Inject
    protected AddressTool ads;
    @Inject
    protected MapService mapService;
    @Inject
    protected CityRepository cityRepository;
    @Inject
    protected StreetRepository streetRepository;
    @Inject
    protected AppBaseService appBaseService;
    protected static final Set<Function<Long, Boolean>> checkUsedFuncs = new LinkedHashSet<Function<Long, Boolean>>();
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public boolean check(String wsdlUrl) {
        return this.ads.doCanSearch(wsdlUrl);
    }

    @Override
    public Map<String, Object> validate(String wsdlUrl, String search) {
        return this.ads.doSearch(wsdlUrl, search);
    }

    @Override
    public com.qas.web_2005_02.Address select(String wsdlUrl, String moniker) {
        return this.ads.doGetAddress(wsdlUrl, moniker);
    }

    @Override
    public int export(String path) throws IOException {
        List addresses = this.addressRepo.all().filter("self.certifiedOk IS FALSE").fetch();
        CSVWriter csv = new CSVWriter((Writer)new FileWriter(path), "|".charAt(0), '\u0000');
        ArrayList<String> header = new ArrayList<String>();
        header.add("Id");
        header.add("AddressL1");
        header.add("AddressL2");
        header.add("AddressL3");
        header.add("AddressL4");
        header.add("AddressL5");
        header.add("AddressL6");
        header.add("CodeINSEE");
        csv.writeNext(header.toArray(new String[header.size()]));
        ArrayList<String> items = new ArrayList<String>();
        for (Address a : addresses) {
            items.add(a.getId() != null ? a.getId().toString() : "");
            items.add(a.getAddressL2() != null ? a.getAddressL2() : "");
            items.add(a.getAddressL3() != null ? a.getAddressL3() : "");
            items.add(a.getAddressL4() != null ? a.getAddressL4() : "");
            items.add(a.getAddressL5() != null ? a.getAddressL5() : "");
            items.add(a.getAddressL6() != null ? a.getAddressL6() : "");
            items.add(a.getInseeCode() != null ? a.getInseeCode() : "");
            csv.writeNext(items.toArray(new String[items.size()]));
            items.clear();
        }
        csv.close();
        LOG.info("{} exported", (Object)path);
        return addresses.size();
    }

    @Override
    public Address createAddress(String addressL2, String addressL3, String addressL4, String addressL5, String addressL6, Country addressL7Country) {
        Address address = new Address();
        address.setAddressL2(addressL2);
        address.setAddressL3(addressL3);
        address.setAddressL4(addressL4);
        address.setAddressL5(addressL5);
        address.setAddressL6(addressL6);
        address.setAddressL7Country(addressL7Country);
        return address;
    }

    @Override
    public Address getAddress(String addressL2, String addressL3, String addressL4, String addressL5, String addressL6, Country addressL7Country) {
        return (Address)((Object)this.addressRepo.all().filter("self.addressL2 = ?1 AND self.addressL3 = ?2 AND self.addressL4 = ?3 AND self.addressL5 = ?4 AND self.addressL6 = ?5 AND self.addressL7Country = ?6", new Object[]{addressL2, addressL3, addressL4, addressL5, addressL6, addressL7Country}).fetchOne());
    }

    @Override
    public boolean checkAddressUsed(Long addressId) {
        LOG.debug("Address Id to be checked = {}", (Object)addressId);
        return checkUsedFuncs.stream().anyMatch(checkUsedFunc -> (Boolean)checkUsedFunc.apply(addressId));
    }

    protected static void registerCheckUsedFunc(Function<Long, Boolean> checkUsedFunc) {
        checkUsedFuncs.add(checkUsedFunc);
    }

    private static boolean checkAddressUsedBase(Long addressId) {
        return JPA.all(PartnerAddress.class).filter("self.address.id = ?1", new Object[]{addressId}).fetchOne() != null || JPA.all(Partner.class).filter("self.mainAddress.id = ?1", new Object[]{addressId}).fetchOne() != null || JPA.all(PickListEntry.class).filter("self.address.id = ?1", new Object[]{addressId}).fetchOne() != null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Optional<Pair<BigDecimal, BigDecimal>> getOrUpdateLatLong(Address address) throws AxelorException, JSONException {
        Preconditions.checkNotNull((Object)((Object)address), (Object)I18n.get((String)"Address cannot be null."));
        Optional<Pair<BigDecimal, BigDecimal>> latLong = this.getLatLong(address);
        if (latLong.isPresent()) {
            return latLong;
        }
        return this.updateLatLong(address);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Optional<Pair<BigDecimal, BigDecimal>> updateLatLong(Address address) throws AxelorException, JSONException {
        Preconditions.checkNotNull((Object)((Object)address), (Object)I18n.get((String)"Address cannot be null."));
        if (this.mapService.isConfigured() && StringUtils.notBlank((CharSequence)address.getFullName())) {
            Map<String, Object> result = this.mapService.getMap(address.getFullName());
            if (result == null) {
                address.setIsValidLatLong(false);
                return Optional.empty();
            }
            address.setIsValidLatLong(true);
            BigDecimal latitude = (BigDecimal)result.get("latitude");
            BigDecimal longitude = (BigDecimal)result.get("longitude");
            this.setLatLong(address, (Pair<BigDecimal, BigDecimal>)Pair.of((Object)latitude, (Object)longitude));
        }
        return this.getLatLong(address);
    }

    @Override
    @Transactional
    public void resetLatLong(Address address) {
        Preconditions.checkNotNull((Object)((Object)address), (Object)I18n.get((String)"Address cannot be null."));
        this.setLatLong(address, (Pair<BigDecimal, BigDecimal>)Pair.of(null, null));
    }

    protected void setLatLong(Address address, Pair<BigDecimal, BigDecimal> latLong) {
        address.setLatit((BigDecimal)latLong.getLeft());
        address.setLongit((BigDecimal)latLong.getRight());
    }

    protected Optional<Pair<BigDecimal, BigDecimal>> getLatLong(Address address) {
        if (address.getLatit() != null && address.getLongit() != null) {
            return Optional.of(Pair.of((Object)address.getLatit(), (Object)address.getLongit()));
        }
        return Optional.empty();
    }

    @Override
    public String computeFullName(Address address) {
        String l2 = address.getAddressL2();
        String l3 = address.getAddressL3();
        String l4 = address.getAddressL4();
        String l5 = address.getAddressL5();
        String l6 = address.getAddressL6();
        return (!Strings.isNullOrEmpty((String)l2) ? l2 : "") + (!Strings.isNullOrEmpty((String)l3) ? " " + l3 : "") + (!Strings.isNullOrEmpty((String)l4) ? " " + l4 : "") + (!Strings.isNullOrEmpty((String)l5) ? " " + l5 : "") + (!Strings.isNullOrEmpty((String)l6) ? " " + l6 : "");
    }

    @Override
    public String computeAddressStr(Address address) {
        StringBuilder addressString = new StringBuilder();
        if (address == null) {
            return "";
        }
        if (address.getAddressL2() != null) {
            addressString.append(address.getAddressL2()).append("\n");
        }
        if (address.getAddressL3() != null) {
            addressString.append(address.getAddressL3()).append("\n");
        }
        if (address.getAddressL4() != null) {
            addressString.append(address.getAddressL4()).append("\n");
        }
        if (address.getAddressL5() != null) {
            addressString.append(address.getAddressL5()).append("\n");
        }
        if (address.getAddressL6() != null) {
            addressString.append(address.getAddressL6());
        }
        if (address.getAddressL7Country() != null) {
            addressString = addressString.append("\n").append(address.getAddressL7Country().getName());
        }
        return addressString.toString();
    }

    @Override
    public void autocompleteAddress(Address address) {
        String zip = address.getZip();
        if (zip == null) {
            return;
        }
        Country country = address.getAddressL7Country();
        List cities = this.cityRepository.findByZipAndCountry(zip, country).fetch();
        City city = cities.size() == 1 ? (City)((Object)cities.get(0)) : null;
        address.setCity(city);
        address.setAddressL6(city != null ? zip + " " + city.getName() : null);
        if (this.appBaseService.getAppBase().getStoreStreets().booleanValue()) {
            List streets = this.streetRepository.all().filter("self.city = :city").bind("city", (Object)city).fetch();
            if (streets.size() == 1) {
                Street street = (Street)((Object)streets.get(0));
                address.setStreet(street);
                String name = street.getName();
                String num = address.getStreetNumber();
                address.setAddressL4(num != null ? num + " " + name : name);
            } else {
                address.setStreet(null);
                address.setAddressL4(null);
            }
        }
    }

    static {
        AddressServiceImpl.registerCheckUsedFunc(AddressServiceImpl::checkAddressUsedBase);
    }
}

