/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.BarcodeTypeConfig;
import com.axelor.apps.base.service.BarcodeGeneratorService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Singleton;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BarcodeGeneratorServiceImpl
implements BarcodeGeneratorService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public InputStream createBarCode(String serialno, BarcodeTypeConfig barcodeTypeConfig, boolean isPadding) throws AxelorException {
        if (serialno != null && barcodeTypeConfig != null) {
            BarcodeFormat barcodeFormat = null;
            switch (barcodeTypeConfig.getName()) {
                case "AZTEC": {
                    barcodeFormat = BarcodeFormat.AZTEC;
                    break;
                }
                case "CODABAR": {
                    barcodeFormat = BarcodeFormat.CODABAR;
                    serialno = this.checkTypeForCodabar(serialno, barcodeFormat);
                    break;
                }
                case "CODE_39": {
                    barcodeFormat = BarcodeFormat.CODE_39;
                    serialno = this.checkTypeForCode39(serialno, barcodeFormat);
                    break;
                }
                case "CODE_128": {
                    barcodeFormat = BarcodeFormat.CODE_128;
                    break;
                }
                case "DATA_MATRIX": {
                    barcodeFormat = BarcodeFormat.DATA_MATRIX;
                    break;
                }
                case "EAN_8": {
                    barcodeFormat = BarcodeFormat.EAN_8;
                    serialno = this.checkTypeForEan8(serialno, barcodeFormat, isPadding);
                    break;
                }
                case "ITF": {
                    barcodeFormat = BarcodeFormat.ITF;
                    serialno = this.checkTypeForItf(serialno, barcodeFormat, isPadding);
                    break;
                }
                case "PDF_417": {
                    barcodeFormat = BarcodeFormat.PDF_417;
                    serialno = this.checkTypeForPdf417(serialno, barcodeFormat, isPadding);
                    break;
                }
                case "QR_CODE": {
                    barcodeFormat = BarcodeFormat.QR_CODE;
                    break;
                }
                case "UPC_A": {
                    barcodeFormat = BarcodeFormat.UPC_A;
                    serialno = this.checkTypeForUpca(serialno, barcodeFormat, isPadding);
                    break;
                }
                case "EAN_13": {
                    barcodeFormat = BarcodeFormat.EAN_13;
                    serialno = this.checkTypeForEan13(serialno, barcodeFormat, isPadding);
                    break;
                }
                default: {
                    throw new AxelorException(4, I18n.get((String)"Barcode format not supported"));
                }
            }
            return this.generateBarcode(serialno, barcodeTypeConfig, barcodeFormat);
        }
        return null;
    }

    public InputStream generateBarcode(String serialno, BarcodeTypeConfig barcodeTypeConfig, BarcodeFormat barcodeFormat) {
        MultiFormatWriter writer = new MultiFormatWriter();
        int height = barcodeTypeConfig.getHeight();
        int width = barcodeTypeConfig.getWidth();
        try {
            BitMatrix bt = writer.encode(serialno, barcodeFormat, width, height);
            BufferedImage image = new BufferedImage(width, height, 1);
            int[] pixels = new int[width * height];
            int index = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    pixels[index++] = bt.get(x, y) ? Color.BLACK.hashCode() : Color.WHITE.hashCode();
                }
            }
            image.setRGB(0, 0, width, height, pixels, 0, width);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", out);
            return new ByteArrayInputStream(out.toByteArray());
        }
        catch (WriterException | IOException e) {
            LOG.trace(e.getMessage(), e);
            return null;
        }
    }

    public String checkTypeForCodabar(String serialno, BarcodeFormat barcodeFormat) throws AxelorException {
        if (this.isNumber(serialno)) {
            return serialno;
        }
        throw new AxelorException(4, I18n.get((String)"Invalid serial number '%s' for '%s' barcode type.It must be digits only"), new Object[]{serialno, barcodeFormat, null});
    }

    public String checkTypeForCode39(String serialno, BarcodeFormat barcodeFormat) throws AxelorException {
        if (serialno.equals(serialno.toUpperCase())) {
            return serialno;
        }
        throw new AxelorException(4, I18n.get((String)"Invalid Serial Number '%s' for '%s' barcode type.Alphabets must be in uppercase only"), new Object[]{serialno, barcodeFormat, null});
    }

    public String checkTypeForItf(String serialno, BarcodeFormat barcodeFormat, Boolean isPadding) throws AxelorException {
        if (isPadding.booleanValue() && serialno.length() % 2 != 0) {
            serialno = serialno + "1";
        }
        if (this.isNumber(serialno) && serialno.length() % 2 == 0) {
            return serialno;
        }
        throw new AxelorException(4, I18n.get((String)"Invalid serial number '%s' for '%s' barcode type.It must be digits only with even number length."), new Object[]{serialno, barcodeFormat, null});
    }

    public String checkTypeForPdf417(String serialno, BarcodeFormat barcodeFormat, Boolean isPadding) throws AxelorException {
        if (isPadding.booleanValue()) {
            serialno = this.addCharPaddingBits(4, serialno, barcodeFormat);
        }
        if (serialno.length() == 4 || serialno.length() == 5) {
            if (this.isAlphanumeric(serialno)) {
                return serialno;
            }
            throw new AxelorException(4, I18n.get((String)"Invalid Serial Number '%s' for '%s' barcode type.It must be alphanumeric"), new Object[]{serialno, barcodeFormat});
        }
        if (serialno.length() == 7 || serialno.length() == 8 || serialno.length() == 9) {
            if (this.isNumber(serialno)) {
                return serialno;
            }
            if (this.isCharacter(serialno)) {
                return serialno;
            }
            throw new AxelorException(4, I18n.get((String)"Invalid Serial Number '%s' for '%s' barcode type.It must be only number or only alphabets"), new Object[]{serialno, barcodeFormat});
        }
        if (serialno.length() > 3 && serialno.length() < 12) {
            return serialno;
        }
        throw new AxelorException(4, I18n.get((String)"Invalid Serial Number '%s' for '%s' barcode type.Its length limit must be greater than %d and less than %d"), new Object[]{serialno, barcodeFormat, 3, 12});
    }

    public String checkTypeForUpca(String serialno, BarcodeFormat barcodeFormat, Boolean isPadding) throws AxelorException {
        if (isPadding.booleanValue()) {
            serialno = this.addPaddingBits(11, serialno, barcodeFormat);
        }
        serialno = this.checkTypeForFixedLength(serialno, barcodeFormat, 11);
        return serialno;
    }

    public String checkTypeForEan8(String serialno, BarcodeFormat barcodeFormat, Boolean isPadding) throws AxelorException {
        if (isPadding.booleanValue()) {
            serialno = this.addPaddingBits(7, serialno, barcodeFormat);
        }
        serialno = this.checkTypeForFixedLength(serialno, barcodeFormat, 7);
        return serialno;
    }

    public String checkTypeForEan13(String serialno, BarcodeFormat barcodeFormat, Boolean isPadding) throws AxelorException {
        if (isPadding.booleanValue()) {
            serialno = this.addPaddingBits(12, serialno, barcodeFormat);
        }
        serialno = this.checkTypeForFixedLength(serialno, barcodeFormat, 12);
        return serialno;
    }

    public String checkTypeForFixedLength(String serialno, BarcodeFormat barcodeFormat, int barcodeLength) throws AxelorException {
        if (this.isNumber(serialno) && barcodeLength == serialno.length()) {
            return serialno;
        }
        throw new AxelorException(4, I18n.get((String)"Invalid serial number '%s' for '%s' barcode type.It must be of %d digits only."), new Object[]{serialno, barcodeFormat, barcodeLength});
    }

    public boolean isNumber(String s) {
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        return true;
    }

    public boolean isAlphanumeric(String s) {
        String PATTERN = "([A-Za-z]+[0-9]|[0-9]+[A-Za-z])[A-Za-z0-9]*";
        Pattern pattern = Pattern.compile(PATTERN);
        return pattern.matcher(s).matches();
    }

    public boolean isCharacter(String s) {
        char[] charArr;
        for (char c : charArr = s.toCharArray()) {
            if (Character.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    public String addPaddingBits(int barcodeLength, String serialno, BarcodeFormat barcodeFormat) throws AxelorException {
        int serialnoLength = serialno.length();
        if (serialnoLength < barcodeLength) {
            int paddingbits = barcodeLength - serialnoLength;
            for (int i = 0; i < paddingbits; ++i) {
                serialno = serialno + "1";
            }
            return serialno;
        }
        throw new AxelorException(4, I18n.get((String)"Invalid Serial Number '%s' for '%s' barcode type.Its Length must be %d"), new Object[]{serialno, barcodeFormat, barcodeLength});
    }

    public String addCharPaddingBits(int barcodeLength, String serialno, BarcodeFormat barcodeFormat) throws AxelorException {
        int serialnoLength = serialno.length();
        if (serialnoLength < barcodeLength) {
            int paddingbits = barcodeLength - serialnoLength;
            for (int i = 0; i < paddingbits; ++i) {
                serialno = serialno + "a";
            }
            return serialno;
        }
        throw new AxelorException(4, I18n.get((String)"Invalid Serial Number '%s' for '%s' barcode type.Its Length must be %d"), new Object[]{serialno, barcodeFormat, barcodeLength});
    }
}

