/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.CurrencyConversionLine;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.CallMethod;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CurrencyService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppBaseService appBaseService;
    private LocalDate today;

    @Inject
    public CurrencyService(AppBaseService appBaseService) {
        this.appBaseService = appBaseService;
        this.today = appBaseService.getTodayDate(Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null));
    }

    public CurrencyService(LocalDate today) {
        this.appBaseService = (AppBaseService)Beans.get(AppBaseService.class);
        this.today = today;
    }

    @CallMethod
    public BigDecimal getCurrencyConversionRate(Currency startCurrency, Currency endCurrency) throws AxelorException {
        return this.getCurrencyConversionRate(startCurrency, endCurrency, this.today);
    }

    public BigDecimal getCurrencyConversionRate(Currency startCurrency, Currency endCurrency, LocalDate date) throws AxelorException {
        if (startCurrency != null && endCurrency != null && !startCurrency.equals((Object)endCurrency)) {
            LocalDate dateToConvert = this.getDateToConvert(date);
            boolean isInverse = true;
            BigDecimal exchangeRate = null;
            CurrencyConversionLine currencyConversionLine = this.getCurrencyConversionLine(startCurrency, endCurrency, dateToConvert);
            if (currencyConversionLine != null) {
                exchangeRate = currencyConversionLine.getExchangeRate();
                isInverse = false;
            } else {
                currencyConversionLine = this.getCurrencyConversionLine(endCurrency, startCurrency, dateToConvert);
                if (currencyConversionLine == null) {
                    throw new AxelorException(4, I18n.get((String)"No currency conversion found from '%s' to '%s' for date %s"), new Object[]{startCurrency.getName(), endCurrency.getName(), dateToConvert});
                }
                exchangeRate = currencyConversionLine.getExchangeRate();
            }
            if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                throw new AxelorException(4, I18n.get((String)"The currency exchange rate from '%s' to '%s' for date %s must be different from zero."), new Object[]{startCurrency.getName(), endCurrency.getName(), dateToConvert});
            }
            return isInverse ? BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_EVEN) : exchangeRate;
        }
        return BigDecimal.ONE;
    }

    private CurrencyConversionLine getCurrencyConversionLine(Currency startCurrency, Currency endCurrency, LocalDate localDate) {
        List<CurrencyConversionLine> currencyConversionLineList = this.appBaseService.getCurrencyConfigurationLineList();
        if (currencyConversionLineList == null) {
            return null;
        }
        this.log.debug("Currency from: {}, Currency to: {}, localDate: {}", new Object[]{startCurrency, endCurrency, localDate});
        for (CurrencyConversionLine ccl : currencyConversionLineList) {
            String cclStartCode = ccl.getStartCurrency().getCode();
            String cclEndCode = ccl.getEndCurrency().getCode();
            String startCode = startCurrency.getCode();
            String endCode = endCurrency.getCode();
            LocalDate fromDate = ccl.getFromDate();
            LocalDate toDate = ccl.getToDate();
            if (!cclStartCode.equals(startCode) || !cclEndCode.equals(endCode) || !fromDate.isBefore(localDate) && !fromDate.equals(localDate) || toDate != null && !toDate.isAfter(localDate) && !toDate.isEqual(localDate)) continue;
            return ccl;
        }
        return null;
    }

    public BigDecimal getAmountCurrencyConvertedAtDate(Currency startCurrency, Currency endCurrency, BigDecimal amount, LocalDate date) throws AxelorException {
        if (startCurrency != null && endCurrency != null && !startCurrency.equals((Object)endCurrency)) {
            return this.getAmountCurrencyConvertedUsingExchangeRate(amount, this.getCurrencyConversionRate(startCurrency, endCurrency, date));
        }
        return amount;
    }

    public BigDecimal getAmountCurrencyConvertedUsingExchangeRate(BigDecimal amount, BigDecimal exchangeRate) throws AxelorException {
        if (exchangeRate.compareTo(BigDecimal.ONE) != 0) {
            return amount.multiply(exchangeRate).setScale(2, RoundingMode.HALF_EVEN);
        }
        return amount;
    }

    public LocalDate getDateToConvert(LocalDate date) {
        if (date == null) {
            date = this.today;
        }
        return date;
    }
}

