/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.service.DMSImportWizardService;
import com.axelor.dms.db.DMSFile;
import com.axelor.dms.db.repo.DMSFileRepository;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMSImportWizardServiceImpl
implements DMSImportWizardService {
    @Inject
    private MetaFiles metaFiles;
    private Logger LOG = LoggerFactory.getLogger(this.getClass());

    @Override
    public void importDMS(MetaFile metaFile) throws AxelorException {
        try {
            File file = MetaFiles.getPath((MetaFile)metaFile).toFile();
            try (ZipFile zipFile = new ZipFile(file);
                 ZipInputStream zipInputStream = this.validateZip(file);){
                this.createDmsTree(zipInputStream, zipFile);
            }
            throw new AxelorException(4, I18n.get((String)"File loaded successfully"));
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new AxelorException(4, I18n.get((String)"Error while processing zip file"));
        }
    }

    /*
     * Exception decompiling
     */
    private ZipInputStream validateZip(File file) throws AxelorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Transactional
    public void createDmsTree(ZipInputStream zipInputStream, ZipFile zipfile) throws IOException {
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        HashMap<String, DMSFile> dmsMap = new HashMap<String, DMSFile>();
        while (zipEntry != null) {
            String fileName = this.getFileName(zipEntry);
            DMSFile dmsFile = new DMSFile();
            dmsFile.setFileName(fileName);
            String parentName = this.getParentName(zipEntry, fileName);
            dmsFile.setParent((DMSFile)dmsMap.get(parentName));
            this.LOG.debug("Praent file: {}", (Object)dmsFile.getParent());
            if (zipEntry.isDirectory()) {
                dmsFile.setIsDirectory(Boolean.valueOf(true));
                dmsFile = ((DMSFileRepository)Beans.get(DMSFileRepository.class)).save(dmsFile);
                dmsMap.put(zipEntry.getName(), dmsFile);
                this.LOG.debug("DMS Directory created: {}", (Object)dmsFile.getFileName());
            } else {
                String fileType = fileName.substring(fileName.indexOf(".") + 1);
                try {
                    File tempDir = File.createTempFile("", "");
                    File file = new File(tempDir, fileName);
                    InputStream is = zipfile.getInputStream(zipEntry);
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
                    MetaFiles.checkType((File)file);
                    MetaFile metaFile = this.metaFiles.upload((InputStream)zipInputStream, fileName);
                    dmsFile.setMetaFile(metaFile);
                    dmsFile = ((DMSFileRepository)Beans.get(DMSFileRepository.class)).save(dmsFile);
                    this.LOG.debug("DMS File created: {}", (Object)dmsFile.getFileName());
                }
                catch (IllegalArgumentException e) {
                    this.LOG.debug("File type is not allowed : {}", (Object)fileType);
                }
            }
            zipEntry = zipInputStream.getNextEntry();
        }
    }

    private String getFileName(ZipEntry zipEntry) {
        String entryName = zipEntry.getName();
        String[] names = entryName.split(File.separator);
        return names[names.length - 1];
    }

    private String getParentName(ZipEntry zipEntry, String fileName) {
        String entryName = zipEntry.getName();
        return entryName.substring(0, entryName.lastIndexOf(File.separator + fileName) + 1);
    }
}

