/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Frequency;
import com.axelor.apps.base.service.FrequencyService;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.i18n.I18n;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;

public class FrequencyServiceImpl
implements FrequencyService {
    @Override
    public String computeSummary(Frequency frequency) {
        int lastCommaIndex;
        StringBuilder summary = new StringBuilder();
        if (frequency.getTypeSelect() != null) {
            if (frequency.getTypeSelect().equals("everyNWeeks")) {
                if (frequency.getEveryNWeeks() == 1) {
                    summary.append(I18n.get((String)"Every week"));
                } else {
                    summary.append(I18n.get((String)"Every")).append(" ").append(frequency.getEveryNWeeks()).append(" ").append(I18n.get((String)"weeks"));
                }
                summary.append("~ ");
                summary.append(I18n.get((String)"THE_SINGULAR", (String)"THE_PLURAL", (int)2));
            } else if (frequency.getTypeSelect().equals("monthDays")) {
                summary.append(I18n.get((String)"Every")).append(" ");
                if (frequency.getFirst().booleanValue()) {
                    summary.append(I18n.get((String)"first"));
                }
                if (frequency.getSecond().booleanValue()) {
                    if (frequency.getFirst().booleanValue()) {
                        summary.append(", ");
                    }
                    summary.append(I18n.get((String)"second"));
                }
                if (frequency.getThird().booleanValue()) {
                    if (frequency.getFirst().booleanValue() || frequency.getSecond().booleanValue()) {
                        summary.append(", ");
                    }
                    summary.append(I18n.get((String)"third"));
                }
                if (frequency.getFourth().booleanValue()) {
                    if (frequency.getFirst().booleanValue() || frequency.getSecond().booleanValue() || frequency.getThird().booleanValue()) {
                        summary.append(", ");
                    }
                    summary.append(I18n.get((String)"fourth"));
                }
                if (frequency.getLast().booleanValue()) {
                    if (frequency.getFirst().booleanValue() || frequency.getSecond().booleanValue() || frequency.getThird().booleanValue() || frequency.getFourth().booleanValue()) {
                        summary.append(", ");
                    }
                    summary.append(I18n.get((String)"last"));
                }
                if ((lastCommaIndex = summary.lastIndexOf(",")) != -1) {
                    summary.replace(lastCommaIndex, lastCommaIndex + 1, " " + I18n.get((String)"and"));
                }
            }
        }
        summary.append(" ");
        if (frequency.getMonday().booleanValue() && frequency.getTuesday().booleanValue() && frequency.getWednesday().booleanValue() && frequency.getThursday().booleanValue() && frequency.getFriday().booleanValue() && !frequency.getSaturday().booleanValue() && !frequency.getSunday().booleanValue()) {
            summary.append(I18n.get((String)"weekdays"));
        } else if (!(!frequency.getSaturday().booleanValue() || !frequency.getSunday().booleanValue() || frequency.getMonday().booleanValue() || frequency.getTuesday().booleanValue() || frequency.getWednesday().booleanValue() || frequency.getThursday().booleanValue() || frequency.getFriday().booleanValue())) {
            summary.append(I18n.get((String)"weekends"));
        } else if (frequency.getMonday().booleanValue() && frequency.getTuesday().booleanValue() && frequency.getWednesday().booleanValue() && frequency.getThursday().booleanValue() && frequency.getFriday().booleanValue() && frequency.getSaturday().booleanValue() && frequency.getSunday().booleanValue()) {
            summary.append(I18n.get((String)"days"));
        } else {
            if (frequency.getMonday().booleanValue()) {
                summary.append(I18n.get((String)"Monday", (String)"Mondays", (int)2));
            }
            if (frequency.getTuesday().booleanValue()) {
                if (frequency.getMonday().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"Tuesday", (String)"Tuesdays", (int)2));
            }
            if (frequency.getWednesday().booleanValue()) {
                if (frequency.getMonday().booleanValue() || frequency.getTuesday().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"Wednesday", (String)"Wednesdays", (int)2));
            }
            if (frequency.getThursday().booleanValue()) {
                if (frequency.getMonday().booleanValue() || frequency.getTuesday().booleanValue() || frequency.getWednesday().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"Thursday", (String)"Thursdays", (int)2));
            }
            if (frequency.getFriday().booleanValue()) {
                if (frequency.getMonday().booleanValue() || frequency.getTuesday().booleanValue() || frequency.getWednesday().booleanValue() || frequency.getThursday().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"Friday", (String)"Fridays", (int)2));
            }
            if (frequency.getSaturday().booleanValue()) {
                if (frequency.getMonday().booleanValue() || frequency.getTuesday().booleanValue() || frequency.getWednesday().booleanValue() || frequency.getThursday().booleanValue() || frequency.getFriday().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"Saturday", (String)"Saturdays", (int)2));
            }
            if (frequency.getSunday().booleanValue()) {
                if (frequency.getMonday().booleanValue() || frequency.getTuesday().booleanValue() || frequency.getWednesday().booleanValue() || frequency.getThursday().booleanValue() || frequency.getFriday().booleanValue() || frequency.getSaturday().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"Sunday", (String)"Sundays", (int)2));
            }
            if ((lastCommaIndex = summary.lastIndexOf(",")) != -1) {
                summary.replace(lastCommaIndex, lastCommaIndex + 1, " " + I18n.get((String)"and"));
            }
        }
        summary.append(" ").append(I18n.get((String)"of")).append(" ");
        if (frequency.getJanuary().booleanValue() && frequency.getFebruary().booleanValue() && frequency.getMarch().booleanValue() && frequency.getApril().booleanValue() && frequency.getMay().booleanValue() && frequency.getJune().booleanValue() && frequency.getJuly().booleanValue() && frequency.getAugust().booleanValue() && frequency.getSeptember().booleanValue() && frequency.getOctober().booleanValue() && frequency.getNovember().booleanValue() && frequency.getDecember().booleanValue()) {
            summary.append(I18n.get((String)"each month"));
        } else {
            if (frequency.getJanuary().booleanValue()) {
                summary.append(I18n.get((String)"January"));
            }
            if (frequency.getFebruary().booleanValue()) {
                if (frequency.getJanuary().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"February"));
            }
            if (frequency.getMarch().booleanValue()) {
                if (frequency.getJanuary().booleanValue() || frequency.getFebruary().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"March"));
            }
            if (frequency.getApril().booleanValue()) {
                if (frequency.getJanuary().booleanValue() || frequency.getFebruary().booleanValue() || frequency.getMarch().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"April"));
            }
            if (frequency.getMay().booleanValue()) {
                if (frequency.getJanuary().booleanValue() || frequency.getFebruary().booleanValue() || frequency.getMarch().booleanValue() || frequency.getApril().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"May"));
            }
            if (frequency.getJune().booleanValue()) {
                if (frequency.getJanuary().booleanValue() || frequency.getFebruary().booleanValue() || frequency.getMarch().booleanValue() || frequency.getApril().booleanValue() || frequency.getMay().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"June"));
            }
            if (frequency.getJuly().booleanValue()) {
                if (frequency.getJanuary().booleanValue() || frequency.getFebruary().booleanValue() || frequency.getMarch().booleanValue() || frequency.getApril().booleanValue() || frequency.getMay().booleanValue() || frequency.getJune().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"July"));
            }
            if (frequency.getAugust().booleanValue()) {
                if (frequency.getJanuary().booleanValue() || frequency.getFebruary().booleanValue() || frequency.getMarch().booleanValue() || frequency.getApril().booleanValue() || frequency.getMay().booleanValue() || frequency.getJune().booleanValue() || frequency.getJuly().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"August"));
            }
            if (frequency.getSeptember().booleanValue()) {
                if (frequency.getJanuary().booleanValue() || frequency.getFebruary().booleanValue() || frequency.getMarch().booleanValue() || frequency.getApril().booleanValue() || frequency.getMay().booleanValue() || frequency.getJune().booleanValue() || frequency.getJuly().booleanValue() || frequency.getAugust().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"September"));
            }
            if (frequency.getOctober().booleanValue()) {
                if (frequency.getJanuary().booleanValue() || frequency.getFebruary().booleanValue() || frequency.getMarch().booleanValue() || frequency.getApril().booleanValue() || frequency.getMay().booleanValue() || frequency.getJune().booleanValue() || frequency.getJuly().booleanValue() || frequency.getAugust().booleanValue() || frequency.getSeptember().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"October"));
            }
            if (frequency.getNovember().booleanValue()) {
                if (frequency.getJanuary().booleanValue() || frequency.getFebruary().booleanValue() || frequency.getMarch().booleanValue() || frequency.getApril().booleanValue() || frequency.getMay().booleanValue() || frequency.getJune().booleanValue() || frequency.getJuly().booleanValue() || frequency.getAugust().booleanValue() || frequency.getSeptember().booleanValue() || frequency.getOctober().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"November"));
            }
            if (frequency.getDecember().booleanValue()) {
                if (frequency.getJanuary().booleanValue() || frequency.getFebruary().booleanValue() || frequency.getMarch().booleanValue() || frequency.getApril().booleanValue() || frequency.getMay().booleanValue() || frequency.getJune().booleanValue() || frequency.getJuly().booleanValue() || frequency.getAugust().booleanValue() || frequency.getSeptember().booleanValue() || frequency.getOctober().booleanValue() || frequency.getNovember().booleanValue()) {
                    summary.append(", ");
                }
                summary.append(I18n.get((String)"December"));
            }
            if ((lastCommaIndex = summary.lastIndexOf(",")) != -1) {
                summary.replace(lastCommaIndex, lastCommaIndex + 1, " " + I18n.get((String)"and"));
            }
        }
        int everyNWeeksCommaIndex = summary.indexOf("~");
        if (everyNWeeksCommaIndex != -1) {
            summary.replace(everyNWeeksCommaIndex, everyNWeeksCommaIndex + 1, ",");
        }
        if (frequency.getEndDate() != null) {
            summary.append(", ");
            summary.append(I18n.get((String)"until"));
            summary.append(" ");
            summary.append(frequency.getEndDate().toString());
        }
        return summary.toString();
    }

    @Override
    public List<LocalDate> getDates(Frequency frequency, LocalDate startDate, LocalDate endDate) {
        HashSet<LocalDate> dates = new HashSet<LocalDate>();
        List<Integer> years = this.getYears(startDate, endDate);
        List<Integer> months = this.getMonths(frequency);
        List<Integer> days = this.getDays(frequency);
        if (frequency.getTypeSelect().equals("monthDays")) {
            List<Integer> occurences = this.getOccurences(frequency);
            for (Integer year : years) {
                for (Integer month : months) {
                    for (Integer day : days) {
                        for (Integer occurence : occurences) {
                            LocalDate date = this.getDay(day, occurence, year, month);
                            if (!DateTool.isBetween((LocalDate)startDate, (LocalDate)endDate, (LocalDate)date)) continue;
                            dates.add(date);
                        }
                    }
                }
            }
        } else {
            Integer leap = frequency.getEveryNWeeks();
            for (Integer year : years) {
                for (Integer day : days) {
                    Calendar cal = Calendar.getInstance();
                    cal.set(1, year);
                    cal.set(2, 0);
                    cal.set(7, day);
                    cal.set(8, 1);
                    do {
                        LocalDate date;
                        if (months.contains(cal.get(2) + 1) && DateTool.isBetween((LocalDate)startDate, (LocalDate)endDate, (LocalDate)(date = LocalDate.of((int)year, cal.get(2) + 1, cal.get(5))))) {
                            dates.add(date);
                        }
                        cal.add(5, leap * 7);
                    } while (cal.get(1) == year.intValue());
                }
            }
        }
        ArrayList<LocalDate> sortedDates = new ArrayList<LocalDate>(dates);
        sortedDates.sort(LocalDate::compareTo);
        return sortedDates;
    }

    public LocalDate getDay(int dayOfWeek, int dayOfWeekInMonth, int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(7, dayOfWeek);
        cal.set(8, dayOfWeekInMonth);
        cal.set(1, year);
        cal.set(2, month - 1);
        return LocalDate.of(year, month, cal.get(5));
    }

    public List<Integer> getYears(LocalDate startDate, LocalDate endDate) {
        ArrayList<Integer> years = new ArrayList<Integer>();
        for (int i = startDate.getYear(); i <= endDate.getYear(); ++i) {
            years.add(i);
        }
        return years;
    }

    @Override
    public List<Integer> getMonths(Frequency frequency) {
        ArrayList<Integer> months = new ArrayList<Integer>();
        if (frequency.getJanuary().booleanValue()) {
            months.add(1);
        }
        if (frequency.getFebruary().booleanValue()) {
            months.add(2);
        }
        if (frequency.getMarch().booleanValue()) {
            months.add(3);
        }
        if (frequency.getApril().booleanValue()) {
            months.add(4);
        }
        if (frequency.getMay().booleanValue()) {
            months.add(5);
        }
        if (frequency.getJune().booleanValue()) {
            months.add(6);
        }
        if (frequency.getJuly().booleanValue()) {
            months.add(7);
        }
        if (frequency.getAugust().booleanValue()) {
            months.add(8);
        }
        if (frequency.getSeptember().booleanValue()) {
            months.add(9);
        }
        if (frequency.getOctober().booleanValue()) {
            months.add(10);
        }
        if (frequency.getNovember().booleanValue()) {
            months.add(11);
        }
        if (frequency.getDecember().booleanValue()) {
            months.add(12);
        }
        return months;
    }

    @Override
    public List<Integer> getDays(Frequency frequency) {
        ArrayList<Integer> days = new ArrayList<Integer>();
        if (frequency.getSunday().booleanValue()) {
            days.add(1);
        }
        if (frequency.getMonday().booleanValue()) {
            days.add(2);
        }
        if (frequency.getTuesday().booleanValue()) {
            days.add(3);
        }
        if (frequency.getWednesday().booleanValue()) {
            days.add(4);
        }
        if (frequency.getThursday().booleanValue()) {
            days.add(5);
        }
        if (frequency.getFriday().booleanValue()) {
            days.add(6);
        }
        if (frequency.getSaturday().booleanValue()) {
            days.add(7);
        }
        return days;
    }

    @Override
    public List<Integer> getOccurences(Frequency frequency) {
        ArrayList<Integer> occurences = new ArrayList<Integer>();
        if (frequency.getFirst().booleanValue()) {
            occurences.add(1);
        }
        if (frequency.getSecond().booleanValue()) {
            occurences.add(2);
        }
        if (frequency.getThird().booleanValue()) {
            occurences.add(3);
        }
        if (frequency.getFourth().booleanValue()) {
            occurences.add(4);
        }
        if (frequency.getLast().booleanValue()) {
            occurences.add(-1);
        }
        return occurences;
    }
}

