/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.AppBase;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import groovy.util.slurpersupport.Node;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wslite.json.JSONArray;
import wslite.json.JSONException;
import wslite.json.JSONObject;
import wslite.rest.ContentType;
import wslite.rest.RESTClient;
import wslite.rest.Response;

public class MapService {
    @Inject
    protected AppBaseService appBaseService;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private BigDecimal lat;
    private BigDecimal lon;

    public JSONObject geocodeGoogle(String qString) throws AxelorException, JSONException {
        JSONObject result;
        JSONArray results;
        if (StringUtils.isBlank((CharSequence)qString)) {
            return null;
        }
        RESTClient restClient = new RESTClient("https://maps.googleapis.com");
        HashMap<String, String> responseQuery = new HashMap<String, String>();
        responseQuery.put("address", qString.trim());
        responseQuery.put("sensor", "false");
        responseQuery.put("key", this.getGoogleMapsApiKey());
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("path", "/maps/api/geocode/json");
        responseMap.put("accept", ContentType.JSON);
        responseMap.put("query", responseQuery);
        responseMap.put("connectTimeout", 5000);
        responseMap.put("readTimeout", 10000);
        responseMap.put("followRedirects", false);
        responseMap.put("useCaches", false);
        responseMap.put("sslTrustAllCerts", true);
        JSONObject restResponse = this.getJSON(restClient.get(responseMap));
        LOG.debug("Gmap response: {}", (Object)restResponse);
        if (restResponse.containsKey((Object)"results") && CollectionUtils.isNotEmpty((Collection)(results = (JSONArray)restResponse.get("results"))) && (result = (JSONObject)results.iterator().next()) != null && result.containsKey((Object)"geometry")) {
            return (JSONObject)((JSONObject)result.get("geometry")).get("location");
        }
        throw new AxelorException((Model)((Object)this.appBaseService.getAppBase()), 3, I18n.get((String)"Response error from map API: %s"), new Object[]{restResponse});
    }

    public Map<String, Object> getMapGoogle(String qString) throws AxelorException, JSONException {
        LOG.debug("Query string: {}", (Object)qString);
        JSONObject googleResponse = this.geocodeGoogle(qString);
        LOG.debug("Google response: {}", (Object)googleResponse);
        if (googleResponse != null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            BigDecimal latitude = new BigDecimal(googleResponse.get("lat").toString());
            BigDecimal longitude = new BigDecimal(googleResponse.get("lng").toString());
            LOG.debug("URL:map/gmaps.html?x=" + latitude + "&y=" + longitude + "&z=18");
            result.put("url", "map/gmaps.html?key=" + this.getGoogleMapsApiKey() + "&x=" + latitude + "&y=" + longitude + "&z=18");
            result.put("latitude", latitude);
            result.put("longitude", longitude);
            return result;
        }
        return null;
    }

    public Map<String, Object> getMapOsm(String qString) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Node node;
            Map attributes;
            BigDecimal latitude = BigDecimal.ZERO;
            BigDecimal longitude = BigDecimal.ZERO;
            RESTClient restClient = new RESTClient("https://nominatim.openstreetmap.org/");
            HashMap<String, Object> mapQuery = new HashMap<String, Object>();
            mapQuery.put("q", qString);
            mapQuery.put("format", "xml");
            mapQuery.put("polygon", true);
            mapQuery.put("addressdetails", true);
            HashMap<String, Object> mapResponse = new HashMap<String, Object>();
            mapResponse.put("path", "/search");
            mapResponse.put("accept", ContentType.JSON);
            mapResponse.put("query", mapQuery);
            mapResponse.put("connectTimeout", 10000);
            mapResponse.put("readTimeout", 10000);
            mapResponse.put("followRedirects", false);
            mapResponse.put("useCaches", false);
            mapResponse.put("sslTrustAllCerts", true);
            Response restResponse = restClient.get(mapResponse);
            GPathResult searchresults = new XmlSlurper().parseText(restResponse.getContentAsString());
            Iterator iterator = searchresults.childNodes();
            if (iterator.hasNext() && (attributes = (node = (Node)iterator.next()).attributes()).containsKey("lat") && attributes.containsKey("lon")) {
                if (BigDecimal.ZERO.compareTo(latitude) == 0) {
                    latitude = new BigDecimal(node.attributes().get("lat").toString());
                }
                if (BigDecimal.ZERO.compareTo(longitude) == 0) {
                    longitude = new BigDecimal(node.attributes().get("lon").toString());
                }
            }
            LOG.debug("OSMap qString: {}, latitude: {}, longitude: {}", new Object[]{qString, latitude, longitude});
            if (BigDecimal.ZERO.compareTo(latitude) != 0 && BigDecimal.ZERO.compareTo(longitude) != 0) {
                result.put("url", "map/oneMarker.html?x=" + latitude + "&y=" + longitude + "&z=18");
                result.put("latitude", latitude);
                result.put("longitude", longitude);
                return result;
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
        return null;
    }

    public Map<String, Object> getMap(String qString) throws AxelorException, JSONException {
        LOG.debug("qString = {}", (Object)qString);
        switch (this.appBaseService.getAppBase().getMapApiSelect()) {
            case 1: {
                return this.getMapGoogle(qString);
            }
            case 2: {
                return this.getMapOsm(qString);
            }
        }
        return null;
    }

    public String getMapUrl(Pair<BigDecimal, BigDecimal> latLong) {
        return this.getMapUrl((BigDecimal)latLong.getLeft(), (BigDecimal)latLong.getRight(), null);
    }

    public String getMapUrl(Pair<BigDecimal, BigDecimal> latLong, String title) {
        return this.getMapUrl((BigDecimal)latLong.getLeft(), (BigDecimal)latLong.getRight(), title);
    }

    public String getMapUrl(BigDecimal latitude, BigDecimal longitude) {
        return this.getMapUrl(latitude, longitude, null);
    }

    public String getMapUrl(BigDecimal latitude, BigDecimal longitude, String title) {
        try {
            switch (this.appBaseService.getAppBase().getMapApiSelect()) {
                case 1: {
                    String uri = "map/gmaps.html";
                    UriBuilder ub = UriBuilder.fromUri((String)"map/gmaps.html");
                    ub.queryParam("key", new Object[]{this.getGoogleMapsApiKey()});
                    ub.queryParam("x", new Object[]{String.valueOf(latitude)});
                    ub.queryParam("y", new Object[]{String.valueOf(longitude)});
                    ub.queryParam("z", new Object[]{String.valueOf(18)});
                    ub.queryParam("title", new Object[]{title});
                    return ub.build(new Object[0]).toString();
                }
                case 2: {
                    return "map/oneMarker.html?x=" + latitude + "&y=" + longitude + "&z=18";
                }
            }
            return null;
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            return this.getErrorURI(e.getMessage());
        }
    }

    public String getDirectionUrl(String key, Pair<BigDecimal, BigDecimal> departureLatLong, Pair<BigDecimal, BigDecimal> arrivalLatLong) {
        return this.getDirectionUrl(key, (BigDecimal)departureLatLong.getLeft(), (BigDecimal)departureLatLong.getRight(), (BigDecimal)arrivalLatLong.getLeft(), (BigDecimal)arrivalLatLong.getRight());
    }

    public String getDirectionUrl(String key, BigDecimal dLat, BigDecimal dLon, BigDecimal aLat, BigDecimal aLon) {
        String queryParam = "dx=" + dLat + "&dy=" + dLon + "&ax=" + aLat + "&ay=" + aLon;
        if (this.appBaseService.getAppBase().getMapApiSelect() == 2) {
            return "map/osm-directions.html?" + queryParam;
        }
        return "map/directions.html?" + queryParam + "&key=" + key;
    }

    public Map<String, Object> getDirectionMapGoogle(String dString, BigDecimal dLat, BigDecimal dLon, String aString, BigDecimal aLat, BigDecimal aLon) {
        LOG.debug("departureString = {}", (Object)dString);
        LOG.debug("arrivalString = {}", (Object)aString);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (!this.checkNotNullNotZero(dLat).booleanValue() || !this.checkNotNullNotZero(dLon).booleanValue()) {
                this.getGoogleResponse(dString);
                dLat = this.lat;
                dLon = this.lon;
            }
            LOG.debug("departureLat = {}, departureLng={}", (Object)dLat, (Object)dLon);
            if (!this.checkNotNullNotZero(aLat).booleanValue() || !this.checkNotNullNotZero(aLon).booleanValue()) {
                this.getGoogleResponse(aString);
                aLat = this.lat;
                aLon = this.lon;
            }
            LOG.debug("arrivalLat = {}, arrivalLng={}", (Object)aLat, (Object)aLon);
            if (this.checkNotNullNotZero(dLat).booleanValue() && this.checkNotNullNotZero(dLon).booleanValue() && this.checkNotNullNotZero(aLon).booleanValue() && this.checkNotNullNotZero(aLat).booleanValue()) {
                result.put("url", "map/directions.html?key=" + this.getGoogleMapsApiKey() + "&dx=" + dLat + "&dy=" + dLon + "&ax=" + aLat + "&ay=" + aLon);
                result.put("aLat", aLat);
                result.put("dLat", dLat);
                return result;
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
        return null;
    }

    protected void getGoogleResponse(String key) throws AxelorException, JSONException {
        JSONObject googleResponse = this.geocodeGoogle(key);
        this.lat = this.lon = BigDecimal.ZERO;
        if (googleResponse != null) {
            this.lat = new BigDecimal(googleResponse.get("lat").toString());
            this.lon = new BigDecimal(googleResponse.get("lng").toString());
        }
    }

    protected Boolean checkNotNullNotZero(BigDecimal value) {
        Boolean flag = false;
        if (value != null && BigDecimal.ZERO.compareTo(value) != 0) {
            flag = true;
        }
        return flag;
    }

    public void testGMapService() throws AxelorException, JSONException {
        RESTClient restClient = new RESTClient("https://maps.googleapis.com");
        HashMap<String, String> responseQuery = new HashMap<String, String>();
        responseQuery.put("address", "google");
        responseQuery.put("sensor", "false");
        responseQuery.put("key", this.getGoogleMapsApiKey());
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("path", "/maps/api/geocode/json");
        responseMap.put("accept", ContentType.JSON);
        responseMap.put("query", responseQuery);
        responseMap.put("connectTimeout", 5000);
        responseMap.put("readTimeout", 10000);
        responseMap.put("followRedirects", false);
        responseMap.put("useCaches", false);
        responseMap.put("sslTrustAllCerts", true);
        Response response = restClient.get(responseMap);
        this.getJSON(response);
    }

    private JSONObject getJSON(Response response) throws AxelorException, JSONException {
        LOG.debug("Gmap connection status code: {}, message: {}", (Object)response.getStatusCode(), (Object)response.getStatusMessage());
        AppBase appBase = this.appBaseService.getAppBase();
        if (response.getStatusCode() != 200) {
            String msg = String.format("%d: %s", response.getStatusCode(), response.getStatusMessage());
            throw new AxelorException((Model)((Object)appBase), 4, msg);
        }
        JSONObject json = new JSONObject(response.getContentAsString());
        String status = json.getString("status");
        if (!"OK".equalsIgnoreCase(status)) {
            String msg = json.has("error_message") ? String.format("%s: %s", status, json.getString("error_message")) : status;
            throw new AxelorException((Model)((Object)appBase), 4, msg);
        }
        return json;
    }

    public String getMapURI(String name) {
        return this.appBaseService.getAppBase().getMapApiSelect() == 1 ? this.getMapURI(name, null) : this.getOsmMapURI(name, null);
    }

    public String getMapURI(String name, Long id) {
        String uri = "map/gmap-objs.html";
        try {
            UriBuilder ub = UriBuilder.fromUri((String)"map/gmap-objs.html");
            ub.queryParam("key", new Object[]{this.getGoogleMapsApiKey()});
            ub.queryParam("object", new Object[]{name});
            if (id != null) {
                ub.queryParam("id", new Object[]{id});
            }
            return ub.build(new Object[0]).toString();
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            return this.getErrorURI(e.getMessage());
        }
    }

    private String getErrorURI(String msg) {
        String uri = "map/error.html";
        try {
            UriBuilder ub = UriBuilder.fromUri((String)"map/error.html");
            ub.queryParam("msg", new Object[]{msg});
            return ub.build(new Object[0]).toString();
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            return "map/error.html";
        }
    }

    public String getGoogleMapsApiKey() {
        Preconditions.checkArgument((boolean)StringUtils.notBlank((CharSequence)this.appBaseService.getAppBase().getGoogleMapsApiKey()), (Object)I18n.get((String)"Google Maps API key is missing in configuration."));
        return this.appBaseService.getAppBase().getGoogleMapsApiKey();
    }

    public boolean isConfigured() {
        switch (this.appBaseService.getAppBase().getMapApiSelect()) {
            case 1: {
                return StringUtils.notBlank((CharSequence)this.appBaseService.getAppBase().getGoogleMapsApiKey());
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public String getOsmMapURI(String name) {
        return this.getOsmMapURI(name, null);
    }

    public String getOsmMapURI(String name, Long id) {
        String uri = "map/osm-objs.html";
        try {
            UriBuilder ub = UriBuilder.fromUri((String)"map/osm-objs.html");
            ub.queryParam("object", new Object[]{name});
            if (id != null) {
                ub.queryParam("id", new Object[]{id});
            }
            return ub.build(new Object[0]).toString();
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            return this.getErrorURI(e.getMessage());
        }
    }

    public Map<String, Object> getDirectionMapOsm(String dString, BigDecimal dLat, BigDecimal dLon, String aString, BigDecimal aLat, BigDecimal aLon) {
        LOG.debug("departureString = {}", (Object)dString);
        LOG.debug("arrivalString = {}", (Object)aString);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (!this.checkNotNullNotZero(dLat).booleanValue() || !this.checkNotNullNotZero(dLon).booleanValue()) {
                this.getOsmResponse(dString);
                dLat = this.lat;
                dLon = this.lon;
            }
            LOG.debug("departureLat = {}, departureLng={}", (Object)dLat, (Object)dLon);
            if (!this.checkNotNullNotZero(aLat).booleanValue() || !this.checkNotNullNotZero(aLon).booleanValue()) {
                this.getOsmResponse(aString);
                aLat = this.lat;
                aLon = this.lon;
            }
            LOG.debug("arrivalLat = {}, arrivalLng={}", (Object)aLat, (Object)aLon);
            if (this.checkNotNullNotZero(dLat).booleanValue() && this.checkNotNullNotZero(dLon).booleanValue() && this.checkNotNullNotZero(aLon).booleanValue() && this.checkNotNullNotZero(aLat).booleanValue()) {
                result.put("url", "map/osm-directions.html?dx=" + dLat + "&dy=" + dLon + "&ax=" + aLat + "&ay=" + aLon);
                result.put("aLat", aLat);
                result.put("dLat", dLat);
                return result;
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
        return null;
    }

    protected void getOsmResponse(String qString) throws AxelorException, JSONException {
        Map<String, Object> osmResponse = this.getMapOsm(qString);
        this.lat = this.lon = BigDecimal.ZERO;
        if (osmResponse != null) {
            this.lat = new BigDecimal(osmResponse.get("latitude").toString());
            this.lon = new BigDecimal(osmResponse.get("longitude").toString());
        }
    }
}

